/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.script;

import java.util.Collection;
import java.util.HashMap;
import org.dbdoclet.trafo.script.AttributeRule;
import org.dbdoclet.trafo.script.NodeRule;
import org.dbdoclet.trafo.script.Section;

public class Namespace {
    private HashMap<String, AttributeRule> attributeRuleMap;
    private String name;
    private HashMap<String, NodeRule> nodeRuleMap;
    private HashMap<String, Section> sectionMap;

    public Namespace(String name) {
        this.setName(name);
        this.sectionMap = new HashMap();
        this.nodeRuleMap = new HashMap();
        this.attributeRuleMap = new HashMap();
    }

    public void addAttributeRule(AttributeRule attributeRule) {
        if (attributeRule == null) {
            return;
        }
        this.attributeRuleMap.put(attributeRule.getName(), attributeRule);
    }

    public void addNodeRule(NodeRule nodeRule) {
        if (nodeRule == null) {
            return;
        }
        this.nodeRuleMap.put(nodeRule.getName(), nodeRule);
    }

    public void addSection(Section section) {
        if (section == null) {
            return;
        }
        this.sectionMap.put(section.getName(), section);
    }

    public AttributeRule findAttributeRule(String name) {
        return this.attributeRuleMap.get(name);
    }

    public NodeRule findNodeRule(String name) {
        return this.nodeRuleMap.get(name);
    }

    public Section findSection(String name) {
        return this.sectionMap.get(name);
    }

    public Collection<AttributeRule> getAttributeRules() {
        return this.attributeRuleMap.values();
    }

    public String getName() {
        return this.name;
    }

    public Collection<NodeRule> getNodeRules() {
        return this.nodeRuleMap.values();
    }

    public Collection<Section> getSections() {
        return this.sectionMap.values();
    }

    public void setName(String name) {
        this.name = name;
    }

    public Section addSection(String sectionName) {
        if (sectionName == null || sectionName.trim().length() == 0) {
            return null;
        }
        Section section = new Section(sectionName);
        this.addSection(section);
        return section;
    }

    public Section findOrCreateSection(String name) {
        Section section = this.findSection(name);
        if (section == null) {
            section = new Section(name);
            this.addSection(section);
        }
        return section;
    }
}

