/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.param;

import java.util.ArrayList;
import org.dbdoclet.service.StringServices;

public class Param<T> {
    private String name;
    private final ArrayList<T> valueList;
    private boolean enabled = true;

    public Param(String name, T value) {
        this.name = name;
        this.valueList = new ArrayList();
        this.valueList.add(value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public T getValue() {
        if (this.valueList.size() == 0) {
            return null;
        }
        return this.valueList.get(0);
    }

    public T getValue(int index) {
        if (index < 0 && index >= this.valueList.size()) {
            return null;
        }
        return this.valueList.get(index);
    }

    public ArrayList<T> getValues() {
        return this.valueList;
    }

    public void setValue(T value) {
        this.valueList.clear();
        this.valueList.add(value);
    }

    public boolean isArray() {
        return this.valueList.size() > 1;
    }

    public String getValueAsText() {
        if (this.valueList == null || this.valueList.size() == 0) {
            return null;
        }
        if (this.valueList.size() == 1) {
            return this.getValue().toString();
        }
        StringBuilder buffer = new StringBuilder();
        for (T value : this.valueList) {
            if (value == null) continue;
            buffer.append(value.toString());
            buffer.append(", ");
        }
        String ret = buffer.toString().trim();
        return StringServices.cutSuffix(ret, ",");
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.name);
        buffer.append(" = ");
        if (this.valueList != null) {
            if (this.valueList.size() == 1) {
                T valueObject = this.valueList.get(0);
                this.appendValueObject(buffer, valueObject);
            }
            if (this.valueList.size() > 1) {
                buffer.append("[ ");
                for (T valueObject : this.valueList) {
                    this.appendValueObject(buffer, valueObject);
                    buffer.append(", ");
                }
                buffer.replace(buffer.length() - 2, buffer.length(), " ]");
            }
        }
        return buffer.toString();
    }

    private void appendValueObject(StringBuilder buffer, Object valueObject) {
        if (valueObject instanceof String) {
            buffer.append('\"');
            buffer.append(valueObject);
            buffer.append('\"');
        } else {
            buffer.append(valueObject);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addValue(T value) {
        this.valueList.add(value);
    }
}

