/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor.javadoc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Emphasis;
import org.dbdoclet.tag.docbook.Link;
import org.dbdoclet.tag.docbook.Xref;
import org.dbdoclet.tag.javadoc.Linkplain;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;

public class LinkplainEditor
extends DocBookEditor {
    private static Log logger = LogFactory.getLog(LinkplainEditor.class);

    @Override
    public EditorInstruction edit(EditorInstruction values) {
        this.setValues(values);
        DocBookTagFactory dbfactory = this.getTagFactory();
        Linkplain linkplain = (Linkplain)this.getHtmlElement();
        String ref = linkplain.getRef();
        logger.debug((Object)("ref=" + ref));
        if (ref != null && ref.length() > 0) {
            String label = linkplain.getTextContent();
            String name = linkplain.getAttribute("name");
            if (label != null && label.length() > 0) {
                Link elem = dbfactory.createLink(label, ref);
                this.setCurrent(elem);
            } else if (name != null && name.length() > 0) {
                Link elem = dbfactory.createLink(name, ref);
                this.setCurrent(elem);
            } else {
                Xref elem = dbfactory.createXref(ref);
                this.setCurrent(elem);
            }
        } else {
            Emphasis elem = dbfactory.createEmphasis(linkplain.getName());
            this.setCurrent(elem);
        }
        this.getParent().appendChild(this.getCurrent());
        this.traverse(false);
        return this.finalizeValues();
    }
}

