/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor.javadoc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Emphasis;
import org.dbdoclet.tag.docbook.Literal;
import org.dbdoclet.tag.javadoc.Link;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;
import org.dbdoclet.xiphias.dom.NodeImpl;

public class LinkEditor
extends DocBookEditor {
    private static Log logger = LogFactory.getLog(LinkEditor.class);

    @Override
    public EditorInstruction edit(EditorInstruction values) {
        this.setValues(values);
        DocBookTagFactory dbfactory = this.getTagFactory();
        NodeImpl parent = this.getParent();
        Link link = (Link)this.getHtmlElement();
        String ref = link.getRef();
        logger.debug((Object)("ref=" + ref));
        if (ref != null && ref.length() > 0) {
            Literal elem;
            String name = link.getName();
            String label = link.getTextContent();
            if (parent instanceof Literal) {
                elem = (Literal)parent;
            } else {
                elem = dbfactory.createLiteral();
                this.setCurrent(elem);
                parent.appendChild(this.getCurrent());
            }
            if (label != null && label.length() > 0) {
                elem.appendChild(dbfactory.createLink(label, ref));
            } else {
                elem.appendChild(dbfactory.createLink(name, ref));
            }
        } else {
            Emphasis elem = dbfactory.createEmphasis(link.getName());
            this.setCurrent(elem);
            parent.appendChild(this.getCurrent());
        }
        this.traverse(false);
        return this.finalizeValues();
    }
}

