/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Emphasis;
import org.dbdoclet.tag.docbook.Entry;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.html.Th;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;

public class ThEditor
extends DocBookEditor {
    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        int rowspan;
        this.setValues(super.edit(values));
        DocBookTagFactory dbfactory = this.getTagFactory();
        boolean decomposeTables = this.script.isParameterOn("DocBook", "decompose-tables", false);
        if (decomposeTables || this.getHtmlElement().isMute()) {
            this.traverse(true);
            return this.finalizeValues();
        }
        Th th = (Th)this.getHtmlElement();
        Entry entry = dbfactory.createEntry();
        entry.setAlign(th.getAlign());
        entry.setChar(th.getChar());
        entry.setCharOff(th.getCharOff());
        entry.setVAlign(th.getVAlign());
        int colspan = th.getColspan();
        if (colspan > 1) {
            entry.setNameSt("c" + th.getIndex());
            entry.setNameEnd("c" + (th.getIndex() + colspan - 1));
        }
        if ((rowspan = th.getRowspan()) > 0) {
            entry.setMorerows(rowspan);
        }
        Para para = dbfactory.createPara();
        para.setFormatType(1);
        Emphasis emph = dbfactory.createEmphasis();
        emph.setRole("bold");
        entry.appendChild(para);
        para.appendChild(emph);
        this.getParent().appendChild(entry);
        this.setCurrent(emph);
        this.traverse(true);
        return this.finalizeValues();
    }
}

