/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Listitem;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;
import org.dbdoclet.xiphias.dom.NodeImpl;

public class TextEditor
extends DocBookEditor {
    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        try {
            this.setValues(super.edit(values));
            DocBookTagFactory dbfactory = this.getTagFactory();
            NodeImpl current = this.getCurrent();
            NodeImpl parent = this.getParent();
            if (this.isSection(parent) && this.getCharacterDataNode().getNodeType() == 3) {
                Para para = dbfactory.createPara();
                parent.appendChild(para);
                this.setParent(para);
                parent = para;
                this.setCurrent(para);
                current = para;
            }
            if (this.isList(parent)) {
                Listitem item = dbfactory.createListitem();
                parent.appendChild(item);
                this.setParent(item);
                parent = item;
                this.setCurrent(item);
                current = item;
            }
            String text = this.getCharacterDataNode().getData();
            if (this.script.isParameterOn("DocBook", "collapse-protected-space", false)) {
                text = text.replace('\u00a0', ' ');
            }
            current.appendChild(text);
            return this.finalizeValues();
        }
        catch (Exception oops) {
            throw new EditorException(oops);
        }
    }
}

