/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Entry;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.html.Table;
import org.dbdoclet.tag.html.Td;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.dbdoclet.xiphias.dom.NodeListImpl;

public class TdEditor
extends DocBookEditor {
    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        int rowspan;
        this.setValues(super.edit(values));
        DocBookTagFactory dbfactory = this.getTagFactory();
        boolean decomposeTables = this.script.isParameterOn("DocBook", "decompose-tables", false);
        if (decomposeTables || this.getHtmlElement().isMute()) {
            this.traverse(true);
            return this.finalizeValues();
        }
        Td td = (Td)this.getHtmlElement();
        Entry entry = dbfactory.createEntry();
        this.copyCommonAttributes(this.getHtmlElement(), entry);
        NodeListImpl children = td.getTrafoChildNodes();
        for (NodeImpl node : children) {
            if (!(node instanceof Table)) continue;
            this.traverse(true);
            return this.finalizeValues();
        }
        entry.setAlign(td.getAlign());
        entry.setChar(td.getChar());
        entry.setCharOff(td.getCharOff());
        entry.setVAlign(td.getVAlign());
        int colspan = td.getColspan();
        if (colspan > 1) {
            entry.setNameSt("c" + td.getIndex());
            entry.setNameEnd("c" + (td.getIndex() + colspan - 1));
        }
        if ((rowspan = td.getRowspan()) > 0) {
            entry.setMorerows(rowspan);
        }
        Para para = dbfactory.createPara();
        para.setFormatType(1);
        entry.appendChild(para);
        para.setParentNode(entry);
        this.getParent().appendChild(entry);
        entry.setParentNode(this.getParent());
        this.setCurrent(para);
        this.traverse(true);
        return this.finalizeValues();
    }
}

