/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Entry;
import org.dbdoclet.tag.docbook.Entrytbl;
import org.dbdoclet.tag.docbook.Row;
import org.dbdoclet.tag.docbook.Table;
import org.dbdoclet.tag.docbook.Tgroup;
import org.dbdoclet.tag.html.Td;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.w3c.dom.Element;

public class TableEditor
extends DocBookEditor {
    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        this.setValues(super.edit(values));
        DocBookTagFactory dbfactory = this.getTagFactory();
        boolean decomposeTables = this.script.isParameterOn("DocBook", "decompose-tables", false);
        if (decomposeTables || this.getHtmlElement().isMute()) {
            this.traverse(true);
            return this.finalizeValues();
        }
        org.dbdoclet.tag.html.Table htmlTable = (org.dbdoclet.tag.html.Table)this.getHtmlElement();
        NodeImpl htmlTableParent = htmlTable.getTrafoParentNode();
        ArrayList<Element> htmlParentChildList = htmlTableParent.getChildElementList();
        NodeImpl tdParent = htmlTable.findParent(Td.class);
        if (tdParent != null) {
            htmlParentChildList = tdParent.getChildElementList();
        }
        NodeImpl parent = this.getParent();
        NodeImpl grandParent = parent.getTrafoParentNode();
        if (parent instanceof Row) {
            if (htmlParentChildList.size() > 1) {
                Entry entry = dbfactory.createEntry();
                parent.appendChild(entry);
                parent = entry;
                this.setParent(entry);
                this.setCurrent(entry);
                this.addTable(dbfactory, htmlTable, parent);
            } else {
                this.addSubtable(dbfactory, htmlTable, parent);
            }
        } else if (grandParent != null && parent instanceof Entry) {
            if (htmlParentChildList.size() > 1) {
                this.addTable(dbfactory, htmlTable, parent);
            } else {
                this.addSubtable(dbfactory, htmlTable, grandParent);
            }
        } else {
            this.addTable(dbfactory, htmlTable, parent);
        }
        return this.finalizeValues();
    }

    private void addSubtable(DocBookTagFactory dbfactory, org.dbdoclet.tag.html.Table htmlTable, NodeImpl parent) {
        ArrayList<String> colWidthList = htmlTable.getColWidths();
        Entrytbl entrytbl = dbfactory.createEntrytbl();
        entrytbl.setCols(htmlTable.getNumOfCols());
        Iterator<String> iterator = colWidthList.iterator();
        int index = 1;
        while (iterator.hasNext()) {
            String width = iterator.next();
            entrytbl.appendChild(dbfactory.createColspec("c" + index, width));
            ++index;
        }
        entrytbl.setParentNode(parent);
        parent.appendChild(entrytbl);
        this.setCurrent(entrytbl);
        this.traverse(true);
    }

    private void addTable(DocBookTagFactory dbfactory, org.dbdoclet.tag.html.Table htmlTable, NodeImpl parent) {
        ArrayList<String> colWidthList = htmlTable.getColWidths();
        Table table = null;
        String caption = htmlTable.getCaption();
        table = caption != null && caption.length() > 0 ? dbfactory.createTable() : dbfactory.createInformaltable();
        this.copyCommonAttributes(htmlTable, table);
        String tableStyle = this.script.getTextParameter("DocBook", "table-style", "all");
        table.setFrame(tableStyle);
        Tgroup tgroup = dbfactory.createTgroup();
        colWidthList = this.editWidths(colWidthList);
        Iterator<String> iterator = colWidthList.iterator();
        int index = 1;
        while (iterator.hasNext()) {
            String width = iterator.next();
            tgroup.appendChild(dbfactory.createColspec("c" + index, width));
            ++index;
        }
        if (!htmlTable.hasBorder()) {
            table.setFrame("none");
        } else {
            table.setFrame("all");
        }
        this.transferId(htmlTable, table);
        tgroup.setCols(colWidthList.size());
        table.appendChild(tgroup);
        parent.appendChild(table);
        this.setCurrent(tgroup);
        this.traverse(true);
    }

    private ArrayList<String> editWidths(ArrayList<String> list) {
        int percent = 0;
        int withoutWidth = 0;
        int index = 0;
        for (String width : list) {
            if (width == null || width.length() == 0) {
                ++withoutWidth;
                continue;
            }
            if ((width = width.trim()).endsWith("%") || width.matches("\\d+")) {
                int i;
                width = width.substring(0, width.length() - 1);
                try {
                    i = Integer.parseInt(width);
                }
                catch (NumberFormatException oops) {
                    continue;
                }
                percent += i;
                list.set(index, String.valueOf(i) + "*");
            }
            ++index;
        }
        index = 0;
        percent = percent < 100 && withoutWidth > 0 ? (100 - percent) / withoutWidth : 10;
        for (String width : list) {
            if (width == null || width.length() == 0) {
                list.set(index, String.valueOf(percent) + "*");
            }
            ++index;
        }
        return list;
    }
}

