/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.tag.docbook.Book;
import org.dbdoclet.tag.docbook.Chapter;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Entry;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.docbook.Part;
import org.dbdoclet.tag.docbook.Refentry;
import org.dbdoclet.tag.docbook.Reference;
import org.dbdoclet.tag.docbook.Refnamediv;
import org.dbdoclet.tag.docbook.Refsection;
import org.dbdoclet.tag.docbook.SectionElement;
import org.dbdoclet.tag.html.P;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.dbdoclet.xiphias.dom.TextImpl;

public class PEditor
extends DocBookEditor {
    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        this.setValues(super.edit(values));
        DocBookTagFactory dbfactory = this.getTagFactory();
        P p = (P)this.getHtmlElement();
        NodeImpl parent = this.getParent();
        Para candidate = dbfactory.createPara();
        this.copyCommonAttributes(p, candidate);
        candidate.setParentNode(parent);
        if (parent instanceof Entry) {
            candidate.setFormatType(1);
        }
        if (!(parent instanceof Para) && candidate.isValidParent(this.script.getTransformPosition(), parent)) {
            this.setCurrent(candidate);
            parent.appendChild(this.getCurrent());
        } else {
            this.setCurrent(parent);
            if (parent instanceof Para && parent.getParentNode() != null) {
                parent.appendChild(new TextImpl(" "));
                this.setParent((NodeImpl)parent.getParentNode());
            }
            if (this.isSection(parent)) {
                if (parent instanceof Book || parent instanceof Part) {
                    Chapter chapter = dbfactory.createChapter("Automatically inserted chapter");
                    parent.appendChild(chapter);
                    this.setCurrent(candidate);
                    chapter.appendChild(this.getCurrent());
                } else if (parent instanceof Reference) {
                    this.setCurrent(candidate);
                    Refentry refEntry = dbfactory.createRefentry();
                    parent.appendChild(refEntry);
                    Refnamediv refNameDiv = dbfactory.createRefnamediv();
                    refNameDiv.appendChild(dbfactory.createRefname("Automatically inserted"));
                    refNameDiv.appendChild(dbfactory.createRefpurpose());
                    refEntry.appendChild(refNameDiv);
                    Refsection refSection = dbfactory.createRefsection();
                    refEntry.appendChild(refSection);
                    refSection.appendChild(this.getCurrent());
                } else {
                    SectionElement sect = (SectionElement)parent;
                    SectionElement firstSectionChild = sect.getFirstSectionChild();
                    if (firstSectionChild != null) {
                        this.setCurrent(candidate);
                        parent.insertBefore(this.getCurrent(), firstSectionChild);
                    }
                }
            }
        }
        this.traverse(true);
        return this.finalizeValues();
    }
}

