/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import java.util.ArrayList;
import org.dbdoclet.tag.docbook.Abstract;
import org.dbdoclet.tag.docbook.Author;
import org.dbdoclet.tag.docbook.BaseTagFactory;
import org.dbdoclet.tag.docbook.Date;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Info;
import org.dbdoclet.tag.docbook.Keyword;
import org.dbdoclet.tag.docbook.Keywordset;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.docbook.Personname;
import org.dbdoclet.tag.docbook.Subject;
import org.dbdoclet.tag.docbook.Subjectset;
import org.dbdoclet.tag.docbook.Subjectterm;
import org.dbdoclet.tag.html.Meta;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.w3c.dom.Node;

public class MetaEditor
extends DocBookEditor {
    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        this.setValues(super.edit(values));
        DocBookTagFactory dbfactory = this.getTagFactory();
        this.traverse(false);
        NodeImpl current = this.getCurrent();
        NodeImpl root = current.getRoot();
        ElementImpl info = (ElementImpl)root.getFirstChildElement();
        if (info == null) {
            info = dbfactory.createInfo();
            root.appendChild(info);
        }
        if (!(info instanceof Info)) {
            info = dbfactory.createInfo();
            root.insertChild(0, info);
        }
        Meta meta = (Meta)this.getHtmlElement();
        String name = meta.getName();
        String content = meta.getContent();
        if (name != null && name.trim().equalsIgnoreCase("author")) {
            this.insertAuthor(dbfactory, info, content);
        }
        if (name != null && name.trim().equalsIgnoreCase("date")) {
            this.insertDate(dbfactory, info, content);
        }
        if (name != null && name.trim().equalsIgnoreCase("description")) {
            this.insertAbstract(dbfactory, info, content);
        }
        if (name != null && name.trim().equalsIgnoreCase("keywords")) {
            this.insertKeywordset(dbfactory, info, content);
        }
        if (name != null && name.trim().equalsIgnoreCase("subject")) {
            this.insertSubjectset(dbfactory, info, content);
        }
        return this.finalizeValues();
    }

    private void insertAuthor(BaseTagFactory dbfactory, ElementImpl info, String content) {
        Author author = dbfactory.createAuthor();
        Personname personname = dbfactory.createPersonname();
        author.appendChild(personname);
        personname.setTextContent(content);
        ArrayList<Author> authorList = info.findChildren(Author.class);
        if (authorList.size() == 0) {
            info.appendChild(author);
        } else {
            info.insertAfter(author, (Node)authorList.get(authorList.size() - 1));
        }
    }

    private void insertDate(BaseTagFactory dbfactory, ElementImpl info, String content) {
        Date date = dbfactory.createDate();
        date.setTextContent(content);
        ArrayList<Date> dateList = info.findChildren(Date.class);
        if (dateList.size() == 0) {
            info.appendChild(date);
        } else {
            info.insertAfter(date, (Node)dateList.get(dateList.size() - 1));
        }
    }

    private void insertAbstract(BaseTagFactory dbfactory, ElementImpl info, String content) {
        Abstract description = dbfactory.createAbstract();
        Para para = dbfactory.createPara(content);
        description.appendChild(para);
        ArrayList<Abstract> abstractList = info.findChildren(Abstract.class);
        if (abstractList.size() == 0) {
            info.appendChild(description);
        } else {
            info.insertAfter(description, (Node)abstractList.get(abstractList.size() - 1));
        }
    }

    private void insertKeywordset(BaseTagFactory dbfactory, ElementImpl info, String content) {
        if (content == null || content.trim().length() == 0) {
            return;
        }
        Keywordset keywordset = dbfactory.createKeywordset();
        for (String token : content.split(",")) {
            Keyword keyword = dbfactory.createKeyword();
            keyword.setTextContent(token.trim());
            keywordset.appendChild(keyword);
        }
        ArrayList<Keywordset> keywordsetList = info.findChildren(Keywordset.class);
        if (keywordsetList.size() == 0) {
            info.appendChild(keywordset);
        } else {
            info.insertAfter(keywordset, (Node)keywordsetList.get(keywordsetList.size() - 1));
        }
    }

    private void insertSubjectset(BaseTagFactory dbfactory, ElementImpl info, String content) {
        if (content == null || content.trim().length() == 0) {
            return;
        }
        ArrayList<Subjectset> subjectsetList = info.findChildren(Subjectset.class);
        Subjectset subjectset = null;
        subjectset = subjectsetList.size() == 0 ? dbfactory.createSubjectset() : (Subjectset)subjectsetList.get(0);
        Subject subject = dbfactory.createSubject();
        subjectset.appendChild(subject);
        Subjectterm subjectterm = dbfactory.createSubjectterm();
        subjectterm.setTextContent(content);
        subject.appendChild(subjectterm);
        info.appendChild(subjectset);
    }
}

