/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Emphasis;
import org.dbdoclet.tag.docbook.Entry;
import org.dbdoclet.tag.docbook.Inlinemediaobject;
import org.dbdoclet.tag.docbook.Link;
import org.dbdoclet.tag.docbook.Mediaobject;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.docbook.Screen;
import org.dbdoclet.tag.docbook.Term;
import org.dbdoclet.tag.docbook.ULink;
import org.dbdoclet.tag.html.Img;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;
import org.dbdoclet.trafo.param.Param;
import org.dbdoclet.xiphias.dom.NodeImpl;

public class ImgEditor
extends DocBookEditor {
    private static Log logger = LogFactory.getLog(ImgEditor.class);
    private static HashMap<String, String> validFormatMap = new HashMap();

    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        NodeImpl parent;
        this.setValues(super.edit(values));
        DocBookTagFactory dbfactory = this.getTagFactory();
        Img img = (Img)this.getHtmlElement();
        Boolean useAbsoluteImagePath = this.script.isParameterOn("DocBook", "use-absolute-image-path", false);
        logger.debug((Object)("Parameter use-absolute-image-path is set to " + useAbsoluteImagePath));
        String imagePath = this.script.getTextParameter("DocBook", "image-path", "./");
        Param<?> param = this.script.getVariable("image-subpath");
        if (imagePath != null && param != null) {
            imagePath = FileServices.appendPath(imagePath, param.getValueAsText());
        }
        List<String> additionalFormats = this.script.getTextParameterList("DocBook", "image-data-formats");
        logger.debug((Object)("Configuration property imagePath is set to " + imagePath));
        String src = img.getSrc();
        logger.debug((Object)("Attribute src has a value of " + src));
        if (src == null || src.length() == 0) {
            return this.finalizeValues();
        }
        if (imagePath != null && imagePath.length() > 0 && !FileServices.isAbsolutePath(src)) {
            src = FileServices.appendFileName(imagePath, src);
        }
        this.validateSrc(src);
        File file = new File(src);
        if (useAbsoluteImagePath.booleanValue()) {
            file = file.getAbsoluteFile();
        }
        if ((parent = this.getParent()) instanceof Emphasis || parent instanceof Entry || parent instanceof Para || parent instanceof Screen || parent instanceof Term || parent instanceof ULink || parent instanceof Link) {
            Inlinemediaobject media = dbfactory.createInlinemediaobject();
            parent.appendChild(media);
            media.setParentNode(this.getCurrent());
            try {
                dbfactory.createHtmlImageData(media, dbfactory, img, file, additionalFormats);
                dbfactory.createFoImageData(media, dbfactory, img, file, additionalFormats);
            }
            catch (IOException oops) {
                throw new EditorException(oops);
            }
        }
        String title = img.getTitle();
        DocBookElement figure = title != null && title.length() > 0 ? dbfactory.createFigure(title) : dbfactory.createInformalfigure();
        Mediaobject media = dbfactory.createMediaobject();
        parent.appendChild(figure);
        figure.appendChild(media);
        try {
            dbfactory.createHtmlImageData(media, dbfactory, img, file, additionalFormats);
            dbfactory.createFoImageData(media, dbfactory, img, file, additionalFormats);
        }
        catch (IOException oops) {
            throw new EditorException(oops);
        }
        this.traverse(false);
        this.setCurrent(parent);
        return this.finalizeValues();
    }

    public String validateFormat(String format) {
        if (format == null) {
            throw new IllegalArgumentException("Parameter format is null!");
        }
        if (validFormatMap.get(format = format.toUpperCase()) != null) {
            return format;
        }
        return "JPG";
    }

    static {
        validFormatMap.put("BASE64", "BASE64");
        validFormatMap.put("BMP", "BMP");
        validFormatMap.put("CGM-BINARY", "CGM-BINARY");
        validFormatMap.put("CGM-CHAR", "CGM-CHAR");
        validFormatMap.put("CGM-CLEAR", "CGM-CLEAR");
        validFormatMap.put("DITROFF", "DITROFF");
        validFormatMap.put("DVI", "DVI");
        validFormatMap.put("EPS", "EPS");
        validFormatMap.put("EQN", "EQN");
        validFormatMap.put("FAX", "FAX");
        validFormatMap.put("GIF", "GIF");
        validFormatMap.put("GIF87a", "GIF87a");
        validFormatMap.put("GIF89a", "GIF89a");
        validFormatMap.put("IGES", "IGES");
        validFormatMap.put("JPEG", "JPEG");
        validFormatMap.put("JPG", "JPG");
        validFormatMap.put("linespecific", "linespecific");
        validFormatMap.put("PCX", "PCX");
        validFormatMap.put("PIC", "PIC");
        validFormatMap.put("PNG", "PNG");
        validFormatMap.put("PS", "PS");
        validFormatMap.put("SGML", "SGML");
        validFormatMap.put("SVG", "SVG");
        validFormatMap.put("TBL", "TBL");
        validFormatMap.put("TEX", "TEX");
        validFormatMap.put("TIFF", "TIFF");
        validFormatMap.put("WMF", "WMF");
        validFormatMap.put("WPG", "WPG");
    }
}

