/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.tag.docbook.Article;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;

public class HtmlEditor
extends DocBookEditor {
    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        this.setValues(super.edit(values));
        DocBookTagFactory dbfactory = this.getTagFactory();
        Article article = dbfactory.createArticle();
        HtmlElement child = this.getHtmlElement();
        String lang = child.getAttribute("lang");
        if (lang == null) {
            lang = child.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
        }
        this.setCurrent(article);
        this.traverse(true);
        article.setAttribute("xmlns", "http://docbook.org/ns/docbook");
        article.setAttribute("version", "5.0");
        if (lang != null) {
            article.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", lang.toLowerCase());
        }
        this.getParent().appendChild(this.getCurrent());
        return this.finalizeValues();
    }
}

