/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import java.util.HashMap;
import org.dbdoclet.option.OptionException;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Title;
import org.dbdoclet.tag.html.A;
import org.dbdoclet.tag.html.Article;
import org.dbdoclet.tag.html.Body;
import org.dbdoclet.tag.html.Center;
import org.dbdoclet.tag.html.Div;
import org.dbdoclet.tag.html.Header;
import org.dbdoclet.tag.html.Html;
import org.dbdoclet.tag.html.HtmlDocument;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.tag.html.Section;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.SectionDetector;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;

public class HeadingEditor
extends DocBookEditor {
    public static HashMap<String, HashMap<String, String>> validHtmlParentPathMap = new HashMap();

    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        try {
            this.setValues(super.edit(values));
            DocBookTagFactory dbfactory = this.getTagFactory();
            HtmlElement headElement = values.getHtmlElement();
            HtmlElement parent = (HtmlElement)headElement.getParentNode();
            if (parent instanceof Section || parent instanceof Article || parent instanceof Header) {
                Title title = dbfactory.createTitle();
                this.getCurrent().appendChild(title);
                this.setCurrent(title);
                return this.finalizeValues();
            }
            SectionDetector sectionDetector = new SectionDetector();
            sectionDetector.setScript(this.script);
            sectionDetector.setTagFactory(dbfactory);
            sectionDetector.edit(values, dbfactory);
            return this.finalizeValues();
        }
        catch (OptionException oops) {
            throw new EditorException(oops);
        }
    }

    static {
        validHtmlParentPathMap.put(new HtmlDocument().getNodeName(), HtmlElement.getAttributeMap());
        validHtmlParentPathMap.put(Html.getTag(), HtmlElement.getAttributeMap());
        validHtmlParentPathMap.put(Body.getTag(), HtmlElement.getAttributeMap());
        validHtmlParentPathMap.put(Center.getTag(), HtmlElement.getAttributeMap());
        validHtmlParentPathMap.put(Div.getTag(), HtmlElement.getAttributeMap());
        validHtmlParentPathMap.put(A.getTag(), HtmlElement.getAttributeMap());
    }
}

