/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.tag.javadoc.JavaDocElement;
import org.dbdoclet.trafo.html.EditorFactoryException;
import org.dbdoclet.trafo.html.IEditor;
import org.dbdoclet.trafo.html.IEditorFactory;
import org.dbdoclet.trafo.html.docbook.LinkManager;
import org.dbdoclet.trafo.html.docbook.editor.CommentEditor;
import org.dbdoclet.trafo.html.docbook.editor.DefaultEditor;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;
import org.dbdoclet.trafo.html.docbook.editor.TextEditor;
import org.dbdoclet.trafo.script.Script;

public class DocBookEditorFactory
implements IEditorFactory {
    private LinkManager linkManager;
    private DocBookTagFactory tagFactory;

    @Override
    public IEditor getChildEditor(HtmlElement child) throws EditorFactoryException {
        Object o;
        if (child == null) {
            throw new EditorFactoryException("Can't create editor for child null!");
        }
        String str = child.getClass().getName();
        str = child instanceof JavaDocElement ? "org.dbdoclet.trafo.html.docbook.editor.javadoc" + str.substring(str.lastIndexOf(46), str.length()) + "Editor" : "org.dbdoclet.trafo.html.docbook.editor" + str.substring(str.lastIndexOf(46), str.length()) + "Editor";
        try {
            Class<?> c = Class.forName(str);
            o = c.newInstance();
            DocBookEditor editor = (DocBookEditor)o;
            editor.setLinkManager(this.linkManager);
            editor.setTagFactory(this.tagFactory);
        }
        catch (ClassNotFoundException oops) {
            DefaultEditor editor = new DefaultEditor();
            editor.setLinkManager(this.linkManager);
            editor.setTagFactory(this.tagFactory);
            return editor;
        }
        catch (InstantiationException oops) {
            throw new EditorFactoryException("Can't create editor for " + child.getNodeName());
        }
        catch (IllegalAccessException oops) {
            throw new EditorFactoryException("No permission to create editor for " + child.getNodeName());
        }
        return (IEditor)o;
    }

    @Override
    public IEditor getCommentEditor() {
        CommentEditor editor = new CommentEditor();
        editor.setLinkManager(this.linkManager);
        editor.setTagFactory(this.tagFactory);
        return editor;
    }

    @Override
    public IEditor getTextEditor() {
        TextEditor editor = new TextEditor();
        editor.setLinkManager(this.linkManager);
        editor.setTagFactory(this.tagFactory);
        return editor;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public void setScript(Script script) {
    }

    public void setTagFactory(DocBookTagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }
}

