/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.ValidationResult;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.DocBookSchemaValidator;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.DocBookVersion;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.docbook.Row;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.tag.html.Table;
import org.dbdoclet.tag.html.Td;
import org.dbdoclet.tag.html.Th;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.IEditor;
import org.dbdoclet.trafo.html.docbook.DocumentElementType;
import org.dbdoclet.trafo.html.docbook.LinkManager;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.xiphias.dom.CharacterDataImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.dbdoclet.xiphias.dom.TextImpl;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class DocBookEditor
implements IEditor {
    protected static final String FSEP = System.getProperty("file.separator");
    protected static final Log logger = LogFactory.getLog(DocBookEditor.class);
    protected static final String AUTOMATICALLY_INSERTED = "Automatically inserted";
    private NodeImpl current;
    private NodeImpl parent;
    private HtmlElement child;
    private CharacterDataImpl characterDataNode;
    private boolean doIgnore;
    private boolean doTraverse;
    private LinkManager linkManager;
    private DocumentElementType documentElementType;
    private DocBookTagFactory tagFactory;
    protected Script script;

    protected void checkNode(Node node) {
        try {
            DocBookSchemaValidator validator = DocBookSchemaValidator.getInstance();
            ValidationResult result = validator.validate(this.script.getTransformPosition(), node);
            if (!result.isValid()) {
                logger.debug((Object)result.getMessage());
            }
        }
        catch (SAXException oops) {
            logger.fatal((Object)"Checking Node failed!", (Throwable)oops);
        }
    }

    public void copyCommonAttributes(HtmlElement html, DocBookElement dbk) {
        logger.debug((Object)("Copy common attributes from " + html + " to " + dbk));
        if (html == null || dbk == null) {
            return;
        }
        String htmlId = html.getId();
        if (htmlId != null) {
            if (this.linkManager != null) {
                dbk.setId(this.linkManager.createUniqueId(htmlId));
            } else {
                logger.warn((Object)("Attribute linkManager must not be null! " + html + ", " + this.toString()));
            }
        }
        if (this.script.isParameterOn("DocBook", "create-condition-attribute", false)) {
            String condition;
            String htmlTitle;
            StringBuilder buffer = new StringBuilder();
            String htmlClass = html.getCssClass();
            if (htmlClass != null) {
                buffer.append(htmlClass);
                buffer.append(",");
            }
            if ((htmlTitle = html.getTitle()) != null) {
                buffer.append(htmlTitle);
                buffer.append(",");
            }
            if ((condition = buffer.toString()).trim().length() > 0) {
                condition = StringServices.cutSuffix(condition, ",");
                dbk.setCondition(condition);
            }
        }
        if (this.script.isParameterOn("DocBook", "create-remap-attribute", false)) {
            this.createRemapAttribute(html, dbk);
            dbk.setLine(html.getLine());
            dbk.setColumn(html.getColumn());
        }
        dbk.setUserData("html", html, null);
    }

    private void createRemapAttribute(HtmlElement html, DocBookElement dbk) {
        String remap = String.format("%s:%d:%d", html.getTagName(), html.getLine(), html.getColumn());
        dbk.setRemap(remap);
    }

    @Override
    public EditorInstruction edit(EditorInstruction vo) throws EditorException {
        if (vo == null) {
            throw new IllegalArgumentException("Variable vo is null!");
        }
        this.setValues(vo);
        DocBookTagFactory dbfactory = this.getTagFactory();
        if (this.parent instanceof Row) {
            Para para;
            if (!(this.child == null || this.child instanceof Td || this.child instanceof Th || this.child instanceof Table)) {
                para = dbfactory.createPara();
                this.parent.appendChild(dbfactory.createEntry().appendChild(para));
                this.current = this.parent = para;
            }
            if (this.characterDataNode != null && this.characterDataNode instanceof TextImpl) {
                para = dbfactory.createPara();
                this.parent.appendChild(dbfactory.createEntry().appendChild(para));
                this.current = this.parent = para;
            }
        }
        return this.finalizeValues();
    }

    protected EditorInstruction finalizeValues() {
        EditorInstruction values = new EditorInstruction(this.script);
        values.doIgnore(this.doIgnore);
        values.doTraverse(this.doTraverse);
        values.setHtmlElement(this.child);
        values.setCurrent(this.current);
        values.setParent(this.parent);
        values.setCharacterDataNode(this.characterDataNode);
        this.checkNode(this.current);
        return values;
    }

    public CharacterDataImpl getCharacterDataNode() {
        return this.characterDataNode;
    }

    public NodeImpl getCurrent() {
        return this.current;
    }

    private DocBookVersion getDocBookVersion() {
        DocBookTagFactory dbfactory = this.getTagFactory();
        if (dbfactory == null) {
            throw new IllegalStateException("The field dbfactory must not be null!");
        }
        DocBookVersion docBookVersion = dbfactory.getDocBookVersion();
        if (docBookVersion == null) {
            throw new IllegalStateException("The field docBookVersion must not be null!");
        }
        return docBookVersion;
    }

    public DocumentElementType getDocumentElementType() {
        return this.documentElementType;
    }

    public HtmlElement getHtmlElement() {
        return this.child;
    }

    public LinkManager getLinkManager() {
        return this.linkManager;
    }

    public NodeImpl getParent() {
        return this.parent;
    }

    @Override
    public DocBookTagFactory getTagFactory() {
        if (this.tagFactory == null) {
            this.tagFactory = new DocBookTagFactory();
        }
        return this.tagFactory;
    }

    public boolean ignore() {
        return this.doIgnore;
    }

    public void ignore(boolean newDoIgnore) {
        this.doIgnore = newDoIgnore;
    }

    public boolean isDocBook5() {
        DocBookVersion docBookVersion = this.getDocBookVersion();
        return docBookVersion == DocBookVersion.V5_0;
    }

    public boolean isDocBookVersion(DocBookVersion version) {
        if (version == null) {
            throw new IllegalArgumentException("The argument version must not be null!");
        }
        DocBookVersion docBookVersion = this.getDocBookVersion();
        return docBookVersion.equals((Object)version);
    }

    protected boolean isList(NodeImpl parentNode) {
        DocBookElement parent;
        return parentNode instanceof DocBookElement && (parent = (DocBookElement)parentNode).isList();
    }

    protected boolean isSection(NodeImpl parentNode) {
        DocBookElement parent;
        return parentNode instanceof DocBookElement && (parent = (DocBookElement)parentNode).isSection();
    }

    public void setChild(HtmlElement newChild) {
        this.child = newChild;
    }

    public void setCurrent(NodeImpl current) {
        this.current = current;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public void setParent(NodeImpl newParent) {
        this.parent = newParent;
    }

    public void setTagFactory(DocBookTagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }

    public void setTextNode(TextImpl newTextNode) {
        this.characterDataNode = newTextNode;
    }

    public void setValues(EditorInstruction values) {
        this.script = values.getScript();
        if (this.script == null) {
            throw new IllegalStateException("Der Parameter Script darf nicht null sein!");
        }
        this.child = values.getHtmlElement();
        this.current = values.getCurrent();
        this.doIgnore = values.doIgnore();
        this.doTraverse = values.doTraverse();
        this.parent = values.getParent();
        this.characterDataNode = values.getCharacterDataNode();
    }

    public String toString() {
        String buffer = "";
        buffer = buffer + "editor[" + this.getClass().getName() + "]";
        return buffer;
    }

    protected void transferId(HtmlElement html, DocBookElement db) {
        if (html == null) {
            throw new IllegalArgumentException("The argument html must not be null!");
        }
        if (db == null) {
            throw new IllegalArgumentException("The argument db must not be null!");
        }
        String id = html.getId();
        if (id != null && id.length() > 0) {
            db.setId(id);
        }
    }

    public boolean traverse() {
        return this.doTraverse;
    }

    public void traverse(boolean newDoTraverse) {
        this.doTraverse = newDoTraverse;
    }

    protected String validateAlign(String align) {
        return this.tagFactory.validateAlign(align);
    }

    protected String validateSrc(String src) {
        if (src == null) {
            throw new IllegalArgumentException("Parameter src is null!");
        }
        if (src.startsWith("http:") && src.indexOf("?") > 0) {
            src = src.substring(0, src.indexOf("?"));
        }
        return src;
    }
}

