/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.tag.docbook.Anchor;
import org.dbdoclet.tag.docbook.Book;
import org.dbdoclet.tag.docbook.Chapter;
import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.docbook.Part;
import org.dbdoclet.tag.docbook.Refentry;
import org.dbdoclet.tag.docbook.Reference;
import org.dbdoclet.tag.docbook.Refnamediv;
import org.dbdoclet.tag.docbook.Refsection;
import org.dbdoclet.tag.html.Div;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.SectionDetector;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.xiphias.dom.NodeImpl;

public class DivEditor
extends DocBookEditor {
    private static final int TIP = 1;
    private static final int NOTE = 2;
    private static final int WARNING = 3;
    private static final int CAUTION = 4;
    private static final int IMPORTANT = 5;

    private void addAdmonition(DocBookTagFactory dbfactory, int type, String title) {
        DocBookElement admon;
        NodeImpl parent = this.getParent();
        switch (type) {
            case 4: {
                admon = dbfactory.createCaution();
                break;
            }
            case 5: {
                admon = dbfactory.createImportant();
                break;
            }
            case 2: {
                admon = dbfactory.createNote();
                break;
            }
            case 1: {
                admon = dbfactory.createTip();
                break;
            }
            case 3: {
                admon = dbfactory.createWarning();
                break;
            }
            default: {
                admon = null;
            }
        }
        if (admon == null) {
            return;
        }
        if (title != null && title.length() > 0) {
            admon.appendChild(dbfactory.createTitle(title));
        }
        Para para = dbfactory.createPara();
        admon.appendChild(para);
        parent.appendChild(admon);
        this.setCurrent(para);
    }

    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        this.setValues(super.edit(values));
        Script script = values.getScript();
        DocBookTagFactory dbfactory = this.getTagFactory();
        Div div = (Div)this.getHtmlElement();
        SectionDetector sectionDetector = new SectionDetector();
        sectionDetector.setScript(script);
        sectionDetector.setTagFactory(dbfactory);
        if (sectionDetector.isSection(div)) {
            sectionDetector.edit(values, dbfactory);
            this.setValues(values);
            return this.finalizeValues();
        }
        String type = null;
        String id = div.getId();
        String clazz = div.getCssClass();
        String title = div.getTitle();
        NodeImpl parent = this.getParent();
        this.traverse(true);
        this.ignore(false);
        if (id != null && id.length() > 0) {
            type = id.toLowerCase();
        }
        if (type == null && clazz != null && clazz.length() > 0) {
            type = clazz.toLowerCase();
        }
        if (type != null && type.length() > 0) {
            if (type.startsWith("example")) {
                if (title != null && title.length() > 0) {
                    this.setCurrent(dbfactory.createExample(title));
                } else {
                    this.setCurrent(dbfactory.createInformalexample());
                }
                parent.appendChild(this.getCurrent());
                this.getCurrent().setParentNode(parent);
                return this.finalizeValues();
            }
            if (type.startsWith("formalpara")) {
                if (title != null && title.length() > 0) {
                    this.setCurrent(dbfactory.createFormalpara(title));
                } else {
                    this.setCurrent(dbfactory.createFormalpara());
                }
                parent.appendChild(this.getCurrent());
                return this.finalizeValues();
            }
            if (type.startsWith("caution")) {
                this.addAdmonition(dbfactory, 4, title);
                return this.finalizeValues();
            }
            if (type.startsWith("important")) {
                this.addAdmonition(dbfactory, 5, title);
                return this.finalizeValues();
            }
            if (type.startsWith("note")) {
                this.addAdmonition(dbfactory, 2, title);
                return this.finalizeValues();
            }
            if (type.startsWith("tip") || type.startsWith("hint")) {
                this.addAdmonition(dbfactory, 1, title);
                return this.finalizeValues();
            }
            if (type.startsWith("warning")) {
                this.addAdmonition(dbfactory, 3, title);
                return this.finalizeValues();
            }
        }
        if (parent instanceof Book || parent instanceof Part) {
            Chapter chapter = dbfactory.createChapter("Automatically inserted");
            parent.appendChild(chapter);
            Para para = dbfactory.createPara();
            chapter.appendChild(para);
            parent = para;
            this.setCurrent(para);
        }
        if (parent instanceof Reference) {
            Refentry refEntry = dbfactory.createRefentry();
            parent.appendChild(refEntry);
            Refnamediv refNameDiv = dbfactory.createRefnamediv();
            refNameDiv.appendChild(dbfactory.createRefname("Automatically inserted"));
            refNameDiv.appendChild(dbfactory.createRefpurpose());
            refEntry.appendChild(refNameDiv);
            Refsection refSection = dbfactory.createRefsection("Automatically inserted");
            refEntry.appendChild(refSection);
            Para para = dbfactory.createPara();
            refSection.appendChild(para);
            parent = para;
            this.setCurrent(para);
        }
        if (id != null) {
            Anchor anchor = dbfactory.createAnchor();
            this.copyCommonAttributes(this.getHtmlElement(), anchor);
            parent.appendChild(anchor);
        }
        this.traverse(true);
        this.ignore(true);
        return this.finalizeValues();
    }
}

