/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.docbook.Subscript;
import org.dbdoclet.tag.docbook.Superscript;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;
import org.dbdoclet.xiphias.dom.NodeImpl;

public abstract class AbstractInlineEditor
extends DocBookEditor {
    private DocBookElement inlineElement;

    public DocBookElement getInlineElement() {
        return this.inlineElement;
    }

    public void setInlineElement(DocBookElement inlineElement) {
        this.inlineElement = inlineElement;
    }

    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        NodeImpl ancestor;
        this.setValues(super.edit(values));
        this.setCurrent(this.inlineElement);
        this.copyCommonAttributes(this.getHtmlElement(), this.inlineElement);
        DocBookTagFactory dbfactory = this.getTagFactory();
        this.traverse(true);
        NodeImpl parent = this.getParent();
        if ((parent instanceof Subscript || parent instanceof Superscript) && (ancestor = parent.getTrafoParentNode()) != null) {
            ancestor.replaceChild(this.inlineElement, parent);
            this.inlineElement.appendChild(parent);
            this.setCurrent(parent);
            return this.finalizeValues();
        }
        if (!this.inlineElement.isValidParent(this.script.getTransformPosition(), parent)) {
            Para candidate = dbfactory.createPara();
            if (candidate.isValidParent(this.script.getTransformPosition(), parent)) {
                this.setParent(candidate);
                parent.appendChild(candidate);
                candidate.appendChild(this.getCurrent());
            }
        } else {
            this.getCurrent().setParentNode(parent);
            parent.appendChild(this.getCurrent());
        }
        return this.finalizeValues();
    }
}

