/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.service.StringServices;
import org.dbdoclet.tag.docbook.Anchor;
import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Link;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.docbook.Simpara;
import org.dbdoclet.tag.docbook.ULink;
import org.dbdoclet.tag.docbook.Xref;
import org.dbdoclet.tag.html.A;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditor;
import org.dbdoclet.xiphias.dom.NodeImpl;

public class AEditor
extends DocBookEditor {
    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        DocBookElement dbParent;
        this.setValues(super.edit(values));
        DocBookTagFactory dbfactory = this.getTagFactory();
        NodeImpl parent = this.getParent();
        this.traverse(true);
        NodeImpl ancestor = parent;
        if (parent instanceof DocBookElement && (dbParent = (DocBookElement)parent).isSection()) {
            Para para = dbfactory.createPara();
            parent.appendChild(para);
            ancestor = para;
        }
        A htmlA = (A)this.getHtmlElement();
        String name = htmlA.getName();
        String href = htmlA.getHref();
        if (name != null && name.length() > 0) {
            Anchor anchor = dbfactory.createAnchor();
            anchor.setId(this.getLinkManager().createUniqueId(name));
            boolean createXrefLabel = this.script.isParameterOn("DocBook", "create-xref-label", true);
            if (createXrefLabel) {
                anchor.setXrefLabel(StringServices.replace(htmlA.getTextContent(), "\"", "&quot;"));
            }
            ancestor.appendChild(anchor);
        } else if (href != null && !href.equals("#") && href.startsWith("#")) {
            String label = htmlA.getTextContent();
            if (label != null && label.length() > 0) {
                Link link = dbfactory.createLink(this.getLinkManager().getUniqueId(href));
                link.setParentNode(ancestor);
                ancestor.appendChild(link);
                this.setCurrent(link);
            } else {
                Xref xref = dbfactory.createXref(this.getLinkManager().getUniqueId(href));
                xref.setParentNode(ancestor);
                ancestor.appendChild(xref);
                this.setCurrent(ancestor);
            }
        } else {
            DocBookElement linkElement;
            if (this.isDocBook5()) {
                Link link = dbfactory.createLink();
                link.setParentNode(ancestor);
                if (href != null) {
                    link.setHref(href);
                } else {
                    link.setHref("");
                }
                linkElement = link;
            } else {
                ULink ulink = dbfactory.createULink();
                ulink.setParentNode(ancestor);
                ulink.setUrl(href);
                linkElement = ulink;
            }
            if (linkElement.isValidParent(this.script.getTransformPosition(), ancestor)) {
                this.setCurrent(linkElement);
                ancestor.appendChild(this.getCurrent());
                this.getLinkManager().addLink(linkElement);
            } else {
                Simpara candidate = dbfactory.createSimpara();
                candidate.setParentNode(ancestor);
                if (candidate.isValidParent(this.script.getTransformPosition(), ancestor)) {
                    ancestor.appendChild(candidate);
                    candidate.appendChild(ancestor);
                }
            }
        }
        return this.finalizeValues();
    }
}

