/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dbdoclet.option.OptionException;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.tag.docbook.Article;
import org.dbdoclet.tag.docbook.Book;
import org.dbdoclet.tag.docbook.Bridgehead;
import org.dbdoclet.tag.docbook.Chapter;
import org.dbdoclet.tag.docbook.DocBookDocument;
import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.DocBookFragment;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.docbook.Part;
import org.dbdoclet.tag.docbook.Partintro;
import org.dbdoclet.tag.docbook.Refentry;
import org.dbdoclet.tag.docbook.Reference;
import org.dbdoclet.tag.docbook.Refname;
import org.dbdoclet.tag.docbook.Refnamediv;
import org.dbdoclet.tag.docbook.Refpurpose;
import org.dbdoclet.tag.docbook.Refsect1;
import org.dbdoclet.tag.docbook.Refsect2;
import org.dbdoclet.tag.docbook.Refsect3;
import org.dbdoclet.tag.docbook.Refsect4;
import org.dbdoclet.tag.docbook.Refsect5;
import org.dbdoclet.tag.docbook.Sect1;
import org.dbdoclet.tag.docbook.Sect2;
import org.dbdoclet.tag.docbook.Sect3;
import org.dbdoclet.tag.docbook.Sect4;
import org.dbdoclet.tag.docbook.Sect5;
import org.dbdoclet.tag.docbook.Section;
import org.dbdoclet.tag.docbook.Title;
import org.dbdoclet.tag.html.HeadingElement;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.LinkManager;
import org.dbdoclet.trafo.html.docbook.editor.DefaultEditor;
import org.dbdoclet.trafo.html.docbook.editor.HeadingEditor;
import org.dbdoclet.trafo.param.TextParam;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SectionDetector {
    private static Class<?>[] bookMap = new Class[]{Book.class, Chapter.class, Section.class, Section.class, Section.class, Section.class};
    private static Class<?>[] articleMap = new Class[]{Article.class, Section.class, Section.class, Section.class, Section.class, Section.class};
    private static Class<?>[] partIntroMap = new Class[]{Partintro.class, Section.class, Section.class, Section.class, Section.class, Section.class};
    private static Class<?>[] chapterMap = new Class[]{Chapter.class, Section.class, Section.class, Section.class, Section.class, Section.class};
    private static Class<?>[] sect1Map = new Class[]{Sect1.class, Sect2.class, Sect3.class, Sect4.class, Sect5.class, Sect5.class};
    private static Class<?>[] sect2Map = new Class[]{Sect2.class, Sect3.class, Sect4.class, Sect5.class, Sect5.class, Sect5.class};
    private static Class<?>[] sect3Map = new Class[]{Sect3.class, Sect4.class, Sect5.class, Sect5.class, Sect5.class, Sect5.class};
    private static Class<?>[] referenceMap = new Class[]{Reference.class, Refentry.class, Refsect1.class, Refsect2.class, Refsect3.class, Refsect4.class};
    private static Class<?>[] refSect1Map = new Class[]{Refsect1.class, Refsect2.class, Refsect3.class, Refsect4.class, Refsect5.class, Refsect5.class};
    private static Class<?>[] refSect2Map = new Class[]{Refsect2.class, Refsect3.class, Refsect4.class, Refsect5.class, Refsect5.class, Refsect5.class};
    private static Class<?>[] refSect3Map = new Class[]{Refsect3.class, Refsect4.class, Refsect5.class, Refsect5.class, Refsect5.class, Refsect5.class};
    private Class<?>[] map;
    private EditorInstruction values;
    private Script script;
    private DocBookTagFactory dbfactory;
    private LinkManager linkManager;

    public boolean isSection(HtmlElement element) {
        Node parentNode = element.getParentNode();
        if (element instanceof HeadingElement && parentNode != null && !(parentNode instanceof DocumentFragment)) {
            String tagName = ((Element)parentNode).getTagName();
            if (tagName != null && tagName.equalsIgnoreCase("header")) {
                return false;
            }
            if (tagName != null && (tagName.equalsIgnoreCase("section") || tagName.equalsIgnoreCase("article")) && element.isFirstChildElement()) {
                return false;
            }
        }
        return this.getSectionLevel(element) > 0;
    }

    public int getSectionLevel(HtmlElement element) {
        if (element == null) {
            return 0;
        }
        if (element instanceof HeadingElement) {
            return ((HeadingElement)element).getLevel();
        }
        String tagName = element.getTagName();
        if ((tagName = tagName.trim().toLowerCase()).startsWith("h")) {
            tagName = StringServices.cutPrefix(tagName, "h");
            int level = -1;
            try {
                level = Integer.parseInt(tagName);
            }
            catch (NumberFormatException oops) {
                return -1;
            }
            return level;
        }
        TextParam paramClasses = (TextParam)this.script.getParameter("section-detection", "attribute-class");
        String cssClass = element.getCssClass();
        if (cssClass == null || paramClasses == null) {
            return 0;
        }
        for (String regex : paramClasses.getValues()) {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(cssClass);
            if (!matcher.matches()) continue;
            int level = 7;
            int groupCount = matcher.groupCount();
            if (groupCount > 0) {
                String group = matcher.group(groupCount);
                try {
                    level = Integer.parseInt(group);
                }
                catch (NumberFormatException oops) {
                    level = 7;
                }
            }
            return level;
        }
        return 0;
    }

    public void edit(EditorInstruction values, DocBookTagFactory dbfactory) {
        DocBookElement sect;
        this.values = values;
        HtmlElement child = values.getHtmlElement();
        NodeImpl parent = values.getParent();
        if (parent != null) {
            values.setCurrent(parent);
        }
        values.doTraverse(true);
        NodeImpl levelParent = null;
        int level = 7;
        level = child instanceof HeadingElement ? ((HeadingElement)child).getLevel() : this.getSectionLevel(child);
        Element root = this.initMap();
        levelParent = this.findParentForLevel(child, level);
        if (levelParent instanceof DocumentFragment) {
            NodeImpl documentElement = (NodeImpl)levelParent.getUserData("documentElement");
            sect = this.createSectionChild(child, documentElement);
        } else {
            sect = this.createSectionChild(child, levelParent);
        }
        if (sect != null) {
            if (sect instanceof Para) {
                values.doTraverse(false);
                if (parent instanceof Para && parent.getParentNode() != null) {
                    values.setParent((DocBookElement)parent.getParentNode());
                }
                values.setCurrent(values.getParent());
            } else if (levelParent != null) {
                levelParent.appendChild(sect);
                if (sect instanceof Refentry) {
                    Refnamediv refNameDiv = dbfactory.createRefnamediv();
                    Refname refName = dbfactory.createRefname("");
                    Refpurpose refPurpose = dbfactory.createRefpurpose();
                    refNameDiv.appendChild(refName);
                    refNameDiv.appendChild(refPurpose);
                    Refsect1 refSect1 = dbfactory.createRefsect1();
                    sect.appendChild(refNameDiv);
                    sect.appendChild(refSect1);
                    sect = refSect1;
                }
                if (sect instanceof Bridgehead) {
                    values.setCurrent(sect);
                } else {
                    Title title = dbfactory.createTitle();
                    sect.appendChild(title);
                    values.setParent(sect);
                    values.setCurrent(title);
                }
            }
        } else {
            NodeImpl current = values.getCurrent();
            if (current instanceof DocBookElement) {
                sect = (DocBookElement)current;
            }
        }
        String id = child.getId();
        if (sect != null && id != null && id.length() > 0) {
            sect.setId(this.linkManager.createUniqueId(id));
        }
        if (root != null) {
            root.getClass().getName();
        }
    }

    private Element initMap() {
        Element root = this.getDocumentElement();
        if (this.map != null) {
            return root;
        }
        if (this.isRootBook() || this.isRoot(Part.getTag())) {
            this.map = bookMap;
        }
        if (this.isRootArticle()) {
            this.map = articleMap;
        }
        if (this.isRoot(Chapter.getTag())) {
            this.map = chapterMap;
        }
        if (this.isRoot(Partintro.getTag())) {
            this.map = partIntroMap;
        }
        if (this.isRoot("sect1")) {
            this.map = sect1Map;
        }
        if (this.isRoot(Sect2.getTag())) {
            this.map = sect2Map;
        }
        if (this.isRoot(Sect3.getTag())) {
            this.map = sect3Map;
        }
        if (this.isRoot(Reference.getTag())) {
            this.map = referenceMap;
        }
        if (this.isRoot("refsect1")) {
            this.map = refSect1Map;
        }
        if (this.isRoot("refsect2")) {
            this.map = refSect2Map;
        }
        if (this.isRoot("refsect3")) {
            this.map = refSect3Map;
        }
        if (this.map == null) {
            this.map = articleMap;
        }
        return root;
    }

    public boolean isRoot(String tagName) {
        Element firstChild;
        Element root = this.getDocumentElement();
        if (root instanceof DocBookFragment && (firstChild = ((DocBookFragment)root).getFirstChildElement()) != null) {
            root = firstChild;
        }
        if (root == null) {
            throw new IllegalStateException("The field root must not be null!");
        }
        return tagName.equalsIgnoreCase(root.getNodeName());
    }

    public boolean isRootArticle() {
        Element root = this.getDocumentElement();
        if (root instanceof DocBookFragment) {
            root = (Element)root.getUserData("documentElement");
        }
        return root instanceof Article;
    }

    public boolean isRootBook() {
        Element root = this.getDocumentElement();
        if (root instanceof DocBookFragment) {
            root = (Element)root.getUserData("documentElement");
        }
        return root instanceof Book;
    }

    private Element getDocumentElement() {
        NodeImpl rootNode = this.values.getCurrent().getRoot();
        Element root = null;
        if (rootNode instanceof DocBookDocument) {
            DocBookDocument doc = (DocBookDocument)rootNode;
            root = doc.getDocumentElement();
        } else if (rootNode instanceof Element) {
            root = (Element)((Object)rootNode);
        } else {
            throw new IllegalStateException("Root node must be of type DocBookDocument or Element.Found root node of type " + rootNode.getClass().getName() + "!");
        }
        return root;
    }

    public NodeImpl findParentForLevel(HtmlElement header, int level) {
        NodeImpl parent = null;
        Class<?> parentClass = null;
        if (level < 0) {
            level = 0;
        }
        if (level > this.map.length) {
            level = this.map.length - 1;
        }
        block0: for (int i = level - 1; i >= 0; --i) {
            parentClass = this.map[i];
            parent = this.values.getCurrent();
            if (parent == null) continue;
            int tagLevel = this.getSectionLevel(header);
            int parentLevel = this.getSectionLevel((HtmlElement)parent.getUserData("html"));
            while (tagLevel != -1 && parentLevel != -1 && parentLevel >= tagLevel) {
                NodeImpl ancestor = NodeImpl.findParent(parent, parentClass);
                if (ancestor == null) {
                    ancestor = NodeImpl.findParent(parent, DocumentFragment.class);
                }
                if (ancestor == null) break block0;
                parent = ancestor;
                parentLevel = this.getSectionLevel((HtmlElement)parent.getUserData("html"));
            }
            break;
        }
        return parent;
    }

    public DocBookElement createSectionChild(HtmlElement header, NodeImpl levelParent) throws OptionException {
        DocBookElement section = null;
        if (levelParent == null || levelParent instanceof Para || !this.isValidHeader(header)) {
            section = this.dbfactory.createBridgehead();
        }
        if (levelParent instanceof Book || levelParent instanceof Part) {
            section = this.dbfactory.createChapter();
        }
        if (levelParent instanceof Chapter || levelParent instanceof Partintro) {
            section = this.dbfactory.createSection();
        }
        if (levelParent instanceof Article) {
            section = this.dbfactory.createSection();
        }
        if (levelParent instanceof Section) {
            section = this.dbfactory.createSection();
        }
        if (levelParent instanceof Sect1) {
            section = this.dbfactory.createSect2();
        }
        if (levelParent instanceof Sect2) {
            section = this.dbfactory.createSect3();
        }
        if (levelParent instanceof Sect3) {
            section = this.dbfactory.createSect4();
        }
        if (levelParent instanceof Sect4) {
            section = this.dbfactory.createSect5();
        }
        if (levelParent instanceof Sect5) {
            section = this.dbfactory.createSimplesect();
        }
        if (levelParent instanceof Reference) {
            section = this.dbfactory.createRefentry();
        }
        if (levelParent instanceof Refentry) {
            section = this.dbfactory.createRefsect1();
        }
        if (levelParent instanceof Refsect1) {
            section = this.dbfactory.createRefsect2();
        }
        if (levelParent instanceof Refsect2) {
            section = this.dbfactory.createRefsect3();
        }
        if (levelParent instanceof Refsect3) {
            section = this.dbfactory.createRefsect4();
        }
        if (levelParent instanceof Refsect4) {
            section = this.dbfactory.createRefsect5();
        }
        if (levelParent instanceof Refsect5) {
            section = this.dbfactory.createSimplesect();
        }
        if (section != null) {
            DefaultEditor editor = new DefaultEditor();
            editor.setLinkManager(this.linkManager);
            editor.setTagFactory(this.dbfactory);
            editor.setValues(this.values);
            editor.copyCommonAttributes(header, section);
        }
        return section;
    }

    public DocBookElement createSectionPara(Element parent) throws OptionException {
        DocBookElement para;
        if (parent != null && parent instanceof Para) {
            para = (DocBookElement)parent;
        } else {
            para = this.dbfactory.createPara();
            if (para.isValidParent(this.script.getTransformPosition(), (DocBookElement)this.values.getParent())) {
                this.values.getParent().appendChild(para);
            } else {
                para = (DocBookElement)this.values.getParent();
            }
        }
        Bridgehead Bridgehead2 = this.dbfactory.createBridgehead();
        Bridgehead2.appendChild(this.values.getHtmlElement().getTextContent());
        para.appendChild(Bridgehead2);
        return para;
    }

    private boolean isValidHeader(HtmlElement header) {
        boolean rc = header.validateParentPath(HeadingEditor.validHtmlParentPathMap);
        return rc;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    public void setTagFactory(DocBookTagFactory dbfactory) {
        this.dbfactory = dbfactory;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }
}

