/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook;

import java.util.ArrayList;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.tag.docbook.BaseTagFactory;
import org.dbdoclet.tag.docbook.SectionElement;
import org.dbdoclet.trafo.SectionNumberRemover;
import org.dbdoclet.trafo.SpaceNormalizer;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.xiphias.dom.AbstractNodeVisitor;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.w3c.dom.Node;

public class PostprocessStage2
extends AbstractNodeVisitor {
    private final BaseTagFactory dbfactory;
    private final ArrayList<Node> removeList;
    private final Script script;

    public PostprocessStage2(BaseTagFactory dbfactory, Script script, ArrayList<ProgressListener> listeners) {
        super(listeners);
        this.dbfactory = dbfactory;
        this.script = script;
        this.removeList = new ArrayList();
    }

    public void finish() {
        this.removeNodes(this.removeList);
    }

    @Override
    public void accept(Node node) throws Exception {
        NodeImpl elem;
        this.fireProgressEvent(node.toString(), 2);
        if (node instanceof ElementImpl && (elem = (NodeImpl)node) instanceof SectionElement) {
            String titleText;
            SectionElement sect = (SectionElement)elem;
            NodeImpl title = sect.findChildElement("title");
            if (title != null) {
                SectionNumberRemover snr = new SectionNumberRemover();
                snr.setRegex(this.script.getTextParameter("section-detection", "section-numbering-pattern", null));
                title.traverse(snr);
                if (this.script.isParameterOn("DocBook", "title-normalize-space", false)) {
                    SpaceNormalizer sn = new SpaceNormalizer();
                    title.traverse(sn);
                }
            }
            if ((titleText = sect.getTitle()).length() == 0 && !sect.hasContentChildren()) {
                this.removeList.add(sect);
                return;
            }
            if (titleText.length() > 0 && !sect.hasContentChildren()) {
                sect.appendChild(this.dbfactory.createPara(""));
                return;
            }
        }
    }

    @Override
    public void openTag(Node node) throws Exception {
    }

    @Override
    public void closeTag(Node node) throws Exception {
    }
}

