/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.tag.docbook.BaseTagFactory;
import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.Entrytbl;
import org.dbdoclet.tag.docbook.Informaltable;
import org.dbdoclet.tag.docbook.Itemizedlist;
import org.dbdoclet.tag.docbook.Listitem;
import org.dbdoclet.tag.docbook.Orderedlist;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.docbook.Table;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.xiphias.HtmlServices;
import org.dbdoclet.xiphias.dom.AbstractNodeVisitor;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class PostprocessStage1
extends AbstractNodeVisitor {
    private final ArrayList<Node> removeList;
    private final HashMap<Entrytbl, DocBookElement> subtables;
    private final Script script;

    public PostprocessStage1(BaseTagFactory dbfactory, Script script, ArrayList<ProgressListener> listeners) {
        super(listeners);
        this.script = script;
        this.removeList = new ArrayList();
        this.subtables = new HashMap();
    }

    @Override
    public void accept(Node node) {
        this.fireProgressEvent(node.toString(), 2);
        if (node instanceof Text) {
            this.replaceHtmlEntities((Text)node);
        }
        if (node instanceof ElementImpl) {
            NodeImpl elem = (NodeImpl)node;
            this.processPara(elem);
            this.processEntryTbl(elem);
            this.processListItem(elem);
        }
    }

    private void processListItem(NodeImpl elem) {
        if (elem == null || elem.getParentNode() == null) {
            return;
        }
        List<Object> stripPrefixesList = new ArrayList();
        String text = elem.getTextContent();
        if (elem instanceof Listitem && elem.getParentNode() instanceof Itemizedlist) {
            stripPrefixesList = this.script.getTextParameterList("list-detection", "itemized-strip-prefix");
        }
        if (elem instanceof Listitem && elem.getParentNode() instanceof Orderedlist) {
            stripPrefixesList = this.script.getTextParameterList("list-detection", "ordered-strip-prefix");
        }
        for (String stripPrefix : stripPrefixesList) {
            if (!text.startsWith(stripPrefix)) continue;
            Text firstText = elem.findFirstText();
            String firstContent = firstText.getData();
            firstText.setData(StringServices.cutPrefix(firstContent, stripPrefix));
        }
    }

    private void processEntryTbl(NodeImpl elem) {
        NodeImpl node;
        if (elem instanceof Entrytbl && (node = NodeImpl.findParent(elem.getParentNode(), Entrytbl.class)) != null) {
            DocBookElement parentTable = (DocBookElement)NodeImpl.findParent(elem, Table.class);
            if (parentTable == null) {
                parentTable = (DocBookElement)NodeImpl.findParent(elem, Informaltable.class);
            }
            if (parentTable != null) {
                this.subtables.put((Entrytbl)elem, parentTable);
            }
        }
    }

    private void processPara(NodeImpl elem) {
        if (elem instanceof Para && elem.hasSiblingElements() && !elem.hasElementChildren()) {
            String text = elem.getTextContent();
            if ((text = text.replace('\u00a0', ' ')).length() == 0) {
                this.removeList.add(elem);
            }
        }
    }

    public void finish() {
        this.removeNodes(this.removeList);
    }

    public HashMap<Entrytbl, DocBookElement> getSubtables() {
        return this.subtables;
    }

    private void replaceHtmlEntities(Text child) {
        String buffer = HtmlServices.replaceEntities(child.getTextContent());
        child.setTextContent(buffer);
    }

    @Override
    public void openTag(Node node) throws Exception {
    }

    @Override
    public void closeTag(Node node) throws Exception {
    }
}

