/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.tag.docbook.BaseTagFactory;
import org.dbdoclet.tag.docbook.Itemizedlist;
import org.dbdoclet.tag.docbook.Listitem;
import org.dbdoclet.tag.docbook.Orderedlist;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.param.TextParam;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.xiphias.XmlServices;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ListDetector {
    private static final Log logger = LogFactory.getLog(ListDetector.class);
    private final Stack<String> cssClassStack = new Stack();

    public void closeList(EditorInstruction values) {
        HtmlElement child = values.getHtmlElement();
        String cssClass = child.getCssClass();
        logger.trace((Object)String.format("Closing list %s, %s.", cssClass, child));
        NodeImpl parent = values.getParent();
        Script script = values.getScript();
        if (this.isItemizedListElement(child, script) || this.isOrderedListElement(child, script)) {
            return;
        }
        if (this.cssClassStack.size() > 1) {
            this.closeNestedList(cssClass, values);
            parent = values.getParent();
        }
        for (Node previous = child.getPreviousSibling(); previous != null && !(previous instanceof Element); previous = previous.getNextSibling()) {
        }
        if (parent instanceof Listitem) {
            parent = (ElementImpl)parent.getParentNode();
        }
        if (parent instanceof Itemizedlist || parent instanceof Orderedlist) {
            values.setParent((ElementImpl)parent.getParentNode());
            values.setCurrent((ElementImpl)parent.getParentNode());
        }
        this.cssClassStack.clear();
    }

    private void closeNestedList(String cssClass, EditorInstruction values) {
        logger.trace((Object)String.format("closeNestedList %s %s", cssClass, values.getHtmlElement()));
        if (this.cssClassStack.empty()) {
            return;
        }
        String currentCssClass = this.cssClassStack.peek();
        while (this.cssClassStack.size() > 1 && !currentCssClass.equals(cssClass)) {
            Node parentNode;
            this.cssClassStack.pop();
            NodeImpl parent = values.getParent();
            while (parent != null && !(parent instanceof Itemizedlist) && !(parent instanceof Orderedlist)) {
                parentNode = parent.getParentNode();
                if (!(parentNode instanceof ElementImpl)) {
                    logger.warn((Object)("Couldn't find nested list element for HTML element " + values.getHtmlElement() + ". DocBookParent = " + XmlServices.printPath(values.getParent()) + ". Stack = " + this.cssClassStack));
                    parent = null;
                    break;
                }
                parent = (ElementImpl)parentNode;
            }
            if (parent == null) continue;
            parent = (ElementImpl)parent.getParentNode();
            while (parent != null && !(parent instanceof Itemizedlist) && !(parent instanceof Orderedlist)) {
                parentNode = parent.getParentNode();
                if (!(parentNode instanceof ElementImpl)) {
                    logger.warn((Object)("Couldn't find parent list for a nested list for HTML element " + values.getHtmlElement() + ". DocBookParent = " + XmlServices.printPath(values.getParent()) + ". Stack = " + this.cssClassStack));
                    parent = null;
                    break;
                }
                parent = (ElementImpl)parentNode;
            }
            if (parent == null) continue;
            values.setParent(parent);
            values.setCurrent(parent);
        }
    }

    public void edit(EditorInstruction values, BaseTagFactory dbfactory) {
        Script script;
        HtmlElement htmlElement = values.getHtmlElement();
        if (this.isItemizedListElement(htmlElement, script = values.getScript())) {
            this.edit(values, dbfactory, ListType.ITEMIZED);
        } else if (this.isOrderedListElement(htmlElement, script)) {
            this.edit(values, dbfactory, ListType.ORDERED);
        } else if (this.isEndOfList(values, script)) {
            this.closeList(values);
        }
    }

    private boolean isEndOfList(EditorInstruction values, Script script) {
        if (this.cssClassStack.size() == 0) {
            return false;
        }
        HtmlElement htmlElement = values.getHtmlElement();
        while (htmlElement != null) {
            if (this.isItemizedListElement(htmlElement, script) || this.isOrderedListElement(htmlElement, script)) {
                return false;
            }
            Node node = htmlElement.getParentNode();
            if (node instanceof HtmlElement) {
                htmlElement = (HtmlElement)node;
                continue;
            }
            return true;
        }
        return true;
    }

    public void edit(EditorInstruction values, BaseTagFactory dbfactory, ListType type) {
        HtmlElement htmlElement = values.getHtmlElement();
        String cssClass = htmlElement.getCssClass();
        logger.trace((Object)String.format("Editing list element %s, %s.", cssClass, htmlElement));
        NodeImpl parent = values.getParent();
        if (!this.isNestedList(cssClass) && parent instanceof Listitem) {
            parent = (ElementImpl)parent.getParentNode();
        }
        parent = this.createListElement(type, cssClass, dbfactory, parent);
        if (this.isParentList(cssClass)) {
            this.closeNestedList(cssClass, values);
            parent = values.getParent();
        }
        Listitem listItem = dbfactory.createListitem();
        parent.appendChild(listItem);
        values.setParent(listItem);
        values.setCurrent(listItem);
    }

    private NodeImpl createListElement(ListType type, String cssClass, BaseTagFactory dbfactory, NodeImpl parent) {
        if (type == ListType.ITEMIZED && !(parent instanceof Itemizedlist)) {
            Itemizedlist itemizedList = dbfactory.createItemizedlist();
            parent.appendChild(itemizedList);
            parent = itemizedList;
            this.cssClassStack.push(cssClass);
        }
        if (type == ListType.ORDERED && !(parent instanceof Orderedlist)) {
            Orderedlist orderedList = dbfactory.createOrderedlist();
            parent.appendChild(orderedList);
            parent = orderedList;
            this.cssClassStack.push(cssClass);
        }
        return parent;
    }

    public boolean isItemizedListElement(HtmlElement element, Script script) {
        TextParam paramClasses = (TextParam)script.getParameter("list-detection", "itemized-attribute-class");
        String cssClass = element.getCssClass();
        if (cssClass == null || paramClasses == null) {
            return false;
        }
        for (String regex : paramClasses.getValues()) {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(cssClass);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isOrderedListElement(HtmlElement element, Script script) {
        TextParam paramClasses = (TextParam)script.getParameter("list-detection", "ordered-attribute-class");
        String cssClass = element.getCssClass();
        if (cssClass == null || paramClasses == null) {
            return false;
        }
        for (String regex : paramClasses.getValues()) {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(cssClass);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isNestedList(String cssClass) {
        if (cssClass == null) {
            return false;
        }
        if (this.cssClassStack.size() == 0 || !cssClass.equals(this.cssClassStack.peek())) {
            for (String elem : this.cssClassStack) {
                if (!elem.equals(cssClass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isParentList(String cssClass) {
        if (cssClass == null) {
            return false;
        }
        if (this.cssClassStack.size() == 0 || !cssClass.equals(this.cssClassStack.peek())) {
            for (String elem : this.cssClassStack) {
                if (!elem.equals(cssClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum ListType {
        ITEMIZED,
        ORDERED;

    }
}

