/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.jive.PanelProvider;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.progress.ProgressManager;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.tag.docbook.BaseTagFactory;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Index;
import org.dbdoclet.tag.html.HtmlDocument;
import org.dbdoclet.tag.html.HtmlFragment;
import org.dbdoclet.trafo.AbstractTrafoService;
import org.dbdoclet.trafo.TrafoResult;
import org.dbdoclet.trafo.TrafoScriptManager;
import org.dbdoclet.trafo.html.HtmlProvider;
import org.dbdoclet.trafo.html.IHtmlVisitor;
import org.dbdoclet.trafo.html.docbook.DocBookVisitor;
import org.dbdoclet.trafo.html.docbook.HtmlDocBookPanel;
import org.dbdoclet.trafo.html.docbook.PostprocessStage1;
import org.dbdoclet.trafo.html.docbook.PostprocessStage2;
import org.dbdoclet.trafo.html.docbook.PostprocessStage3;
import org.dbdoclet.trafo.html.docbook.PreprocessStage1;
import org.dbdoclet.trafo.param.TextParam;
import org.dbdoclet.trafo.script.Namespace;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.trafo.script.ScriptEvent;
import org.dbdoclet.trafo.script.ScriptListener;
import org.dbdoclet.trafo.script.Section;
import org.dbdoclet.xiphias.NodeSerializer;
import org.dbdoclet.xiphias.dom.DocumentImpl;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeCountVisitor;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.osgi.service.component.ComponentContext;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class HtmlDocBookTrafo
extends AbstractTrafoService
implements PanelProvider,
ScriptListener {
    private final Log logger = LogFactory.getLog(HtmlDocBookTrafo.class);
    private HtmlDocBookPanel htmlDocBookPanel;
    private DocBookTagFactory dbfactory = new DocBookTagFactory();
    private Script script;
    private InputStream in;
    private OutputStream out;
    private ArrayList<ProgressListener> listeners = new ArrayList();

    protected void activate(ComponentContext context) {
        this.logger.info((Object)("Activierung des Bundles " + this.getId()));
    }

    @Override
    public String getId() {
        return "html2docbook";
    }

    @Override
    public JPanel getPanel() {
        this.htmlDocBookPanel = new HtmlDocBookPanel();
        return this.htmlDocBookPanel;
    }

    public Script getScript() {
        return this.script;
    }

    public BaseTagFactory getTagFactory() {
        return this.dbfactory;
    }

    @Override
    public void scriptChanged(ScriptEvent<?> event) {
        if (event.getType() == ScriptEvent.Type.INPUT_FILE_CHANGED) {
            System.out.println("Input File Changed");
        }
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setTagFactory(DocBookTagFactory dbfactory) {
        if (dbfactory != null) {
            this.dbfactory = dbfactory;
        }
    }

    @Override
    public TrafoResult transform(Script script) {
        TrafoResult result = new TrafoResult();
        try {
            String encoding = script.getTextParameter("HTML", "encoding", "UTF-8");
            if (this.htmlDocBookPanel != null) {
                String profileText;
                String profileName = this.htmlDocBookPanel.getProfile();
                if (profileName != null && profileName.trim().length() > 0 && (profileText = ResourceServices.getResourceAsString("profiles/" + profileName + ".her", HtmlDocBookTrafo.class.getClassLoader())) != null) {
                    TrafoScriptManager mgr = new TrafoScriptManager();
                    mgr.parseScript(script, profileText);
                }
                Namespace namespace = script.getNamespace();
                Section section = namespace.findOrCreateSection("HTML");
                section.setParam(new TextParam("encoding", this.htmlDocBookPanel.getSourceEncoding()));
                section = namespace.findOrCreateSection("DocBook");
                section.setParam(new TextParam("language", this.htmlDocBookPanel.getLanguage()));
                section.setParam(new TextParam("document-element", this.htmlDocBookPanel.getDocumentType()));
            }
            DocBookVisitor visitor = new DocBookVisitor();
            visitor.addProgressListeners(this.listeners);
            visitor.setTagFactory(this.dbfactory);
            visitor.setScript(script);
            HtmlProvider htmlProvider = new HtmlProvider(script);
            htmlProvider.setProgressListeners(this.listeners);
            NodeImpl htmlDoc = null;
            ElementImpl documentElement = null;
            String htmlCode = this.retrieveHtmlCode(this.in, encoding);
            boolean isFragment = htmlProvider.isFragment(htmlCode);
            htmlDoc = isFragment ? htmlProvider.parseFragment(htmlCode) : htmlProvider.parseDocument(htmlCode);
            ProgressManager pm = new ProgressManager(this.listeners);
            pm.nextStage();
            NodeCountVisitor nodeCounter = new NodeCountVisitor(this.listeners);
            htmlDoc.traverse(nodeCounter);
            pm.setProgressMaximum(nodeCounter.getNumberOfNodes());
            pm.fireProgressEvent(new ProgressEvent("Preprocess HTML tree...", false));
            PreprocessStage1 preprocessStage1 = new PreprocessStage1(this.listeners);
            htmlDoc.traverse(preprocessStage1);
            preprocessStage1.finish();
            pm.nextStage();
            pm.fireProgressEvent(new ProgressEvent("Transformation...", false));
            pm.setProgressMaximum(nodeCounter.getNumberOfNodes());
            if (isFragment) {
                DocumentFragment fragment = htmlProvider.traverse((HtmlFragment)htmlDoc, (IHtmlVisitor)visitor);
                documentElement = (ElementImpl)((Object)fragment);
            } else {
                Document document = htmlProvider.traverse((HtmlDocument)htmlDoc, (IHtmlVisitor)visitor);
                documentElement = (ElementImpl)document.getDocumentElement();
            }
            pm.nextStage();
            nodeCounter = new NodeCountVisitor(this.listeners);
            pm.fireProgressEvent(new ProgressEvent("Postprocess stage 1...", false));
            documentElement.traverse(nodeCounter);
            pm.setProgressMaximum(nodeCounter.getNumberOfNodes());
            PostprocessStage1 postprocessStage1 = new PostprocessStage1(this.dbfactory, script, this.listeners);
            documentElement.traverse(postprocessStage1);
            postprocessStage1.finish();
            pm.nextStage();
            pm.fireProgressEvent(new ProgressEvent("Postprocess stage 2...", false));
            documentElement.traverse(nodeCounter.reset());
            pm.setProgressMaximum(nodeCounter.getNumberOfNodes());
            PostprocessStage2 postprocessStage2 = new PostprocessStage2(this.dbfactory, script, this.listeners);
            documentElement.traverse(postprocessStage2);
            postprocessStage2.finish();
            new PostprocessStage3(this.dbfactory, postprocessStage1.getSubtables()).process();
            boolean addIndex = script.isParameterOn("DocBook", "add-index", false);
            Index index = this.dbfactory.createIndex();
            if (addIndex && !(documentElement instanceof DocumentFragment) && index.isValidParent(script.getTransformPosition(), documentElement)) {
                documentElement.appendChild(index);
            }
            encoding = script.getTextParameter("DocBook", "encoding", "UTF-8");
            if (isFragment) {
                result.setRootNode(documentElement);
            } else {
                DocumentImpl document = documentElement.getDocument();
                document.setXmlEncoding(encoding);
                result.setRootNode(document);
            }
            if (this.out != null) {
                NodeSerializer serializer = new NodeSerializer();
                serializer.addProgressListeners(this.listeners);
                serializer.setSystemId(this.getSystemId());
                serializer.setEncoding(encoding);
                List<String> chunkElementList = script.getTextParameterList("DocBook", "chunk-elements", new ArrayList<String>());
                for (String chunkElement : chunkElementList) {
                    this.logger.debug((Object)String.format("Adding chunk element %s", chunkElement));
                    int depth = script.getIntParameter("DocBook", String.format("chunk-%s-depth", chunkElement), 1);
                    serializer.addChunkElement(chunkElement, depth);
                }
                OutputStreamWriter writer = new OutputStreamWriter(this.out, encoding);
                if (isFragment) {
                    serializer.write((Node)documentElement, writer);
                } else {
                    DocumentImpl document = documentElement.getDocument();
                    document.setXmlEncoding(encoding);
                    serializer.write((Node)document, writer);
                }
                writer.close();
            }
        }
        catch (Throwable oops) {
            result.setThrowable(oops);
        }
        return result;
    }

    private String retrieveHtmlCode(InputStream in, String encoding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = in.read(buffer);
        while (n != -1) {
            out.write(buffer, 0, n);
            n = in.read(buffer);
        }
        in.close();
        out.close();
        return new String(out.toByteArray(), encoding);
    }

    @Override
    public void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }
}

