/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.docbook;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.tag.docbook.Abstract;
import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.DocBookFragment;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Info;
import org.dbdoclet.tag.html.HtmlDocument;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.tag.html.HtmlFragment;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.IEditorFactory;
import org.dbdoclet.trafo.html.IHtmlVisitor;
import org.dbdoclet.trafo.html.docbook.LinkManager;
import org.dbdoclet.trafo.html.docbook.ListDetector;
import org.dbdoclet.trafo.html.docbook.SectionDetector;
import org.dbdoclet.trafo.html.docbook.editor.DocBookEditorFactory;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.xiphias.XPathServices;
import org.dbdoclet.xiphias.dom.DocumentFragmentImpl;
import org.dbdoclet.xiphias.dom.DocumentImpl;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class DocBookVisitor
implements IHtmlVisitor {
    private static Log logger = LogFactory.getLog(DocBookVisitor.class);
    private ArrayList<ProgressListener> listeners;
    private LinkManager linkManager;
    private DocBookTagFactory dbfactory;
    private Script script;
    private ListDetector listDetector = new ListDetector();
    private DocBookEditorFactory docBookEditorFactory;

    public DocBookVisitor() {
        this.linkManager = new LinkManager();
    }

    public void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    @Override
    public boolean beforeEdit(EditorInstruction values) {
        this.listDetector.edit(values, this.dbfactory);
        SectionDetector sectionDetector = new SectionDetector();
        sectionDetector.setScript(this.script);
        sectionDetector.setTagFactory(this.dbfactory);
        sectionDetector.setLinkManager(this.linkManager);
        HtmlElement htmlElement = values.getHtmlElement();
        if (sectionDetector.isSection(htmlElement)) {
            sectionDetector.edit(values, this.dbfactory);
            return false;
        }
        return true;
    }

    @Override
    public DocumentFragmentImpl createDocumentFragment(HtmlFragment htmlFragment) {
        DocBookFragment fragment = new DocBookFragment();
        ElementImpl documentElement = this.createDocumentElement();
        fragment.setUserData("documentElement", documentElement, null);
        return fragment;
    }

    @Override
    public DocumentImpl createDocument(HtmlDocument htmlDoc) {
        DocumentImpl document = new DocumentImpl();
        ElementImpl documentElement = this.createDocumentElement();
        Info info = this.dbfactory.createInfo();
        documentElement.appendChild(info);
        String title = this.script.getTextParameter("DocBook", "title", null);
        if (title != null && title.trim().length() > 0) {
            info.appendChild(this.dbfactory.createTitle(title));
        } else {
            this.generateTitle(htmlDoc, this.dbfactory, info);
        }
        String abstractText = this.script.getTextParameter("DocBook", "abstract", null);
        if (abstractText != null) {
            Abstract abstractElement = this.dbfactory.createAbstract();
            info.appendChild(abstractElement);
            this.createAbstract(document, abstractElement, abstractText);
        }
        document.setDocumentElement(documentElement);
        documentElement.setDocument(document);
        return document;
    }

    public ElementImpl createDocumentElement() {
        DocBookElement documentElement = this.dbfactory.createSection();
        String tagName = "article";
        if (this.script != null) {
            tagName = this.script.getTextParameter("DocBook", "document-element", "article");
            tagName = tagName.toLowerCase();
        }
        if ((documentElement = this.dbfactory.createElementByName(tagName)) == null) {
            throw new IllegalStateException("Can't create document element " + tagName);
        }
        documentElement.setNamespaceURI("http://docbook.org/ns/docbook");
        documentElement.setAttribute("xmlns", "http://docbook.org/ns/docbook");
        documentElement.setAttribute("version", "5.0");
        documentElement.setAttribute("xmlns:xl", "http://www.w3.org/1999/xlink");
        documentElement.setAttribute("xmlns:xi", "http://www.w3.org/2001/XInclude");
        String language = this.script.getTextParameter("DocBook", "language", null);
        logger.debug((Object)("Profile: Parameter language = " + language));
        if (language == null) {
            language = this.detectLanguage(documentElement);
            logger.debug((Object)("Detected language from HTML = " + language));
            if (language == null) {
                language = Locale.getDefault().getLanguage().toLowerCase();
                logger.debug((Object)("Using default language from JVM = " + language));
            }
        }
        if (language != null) {
            documentElement.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", language);
        }
        return documentElement;
    }

    @Override
    public IEditorFactory getEditorFactory() {
        if (this.docBookEditorFactory == null) {
            this.docBookEditorFactory = new DocBookEditorFactory();
            this.docBookEditorFactory.setLinkManager(this.linkManager);
            this.docBookEditorFactory.setScript(this.script);
            this.docBookEditorFactory.setTagFactory(this.dbfactory);
        }
        return this.docBookEditorFactory;
    }

    @Override
    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    public void setTagFactory(DocBookTagFactory dbfactory) {
        this.dbfactory = dbfactory;
    }

    private void createAbstract(Document doc, Abstract abstractElement, String abstractText) {
        abstractText = abstractText.trim().startsWith("<") ? "<abstract>" + abstractText + "</abstract>" : "<abstract><para>" + abstractText + "</para></abstract>";
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document docAbstract = documentBuilder.parse(new InputSource(new StringReader(abstractText)));
            Element documentElement = docAbstract.getDocumentElement();
            documentElement = (Element)doc.importNode(documentElement, true);
            if (documentElement != null && documentElement.hasChildNodes()) {
                NodeList childList = documentElement.getChildNodes();
                for (int i = 0; i < childList.getLength(); ++i) {
                    Node child = childList.item(i);
                    abstractElement.appendChild(child);
                }
            }
        }
        catch (Exception oops) {
            logger.error((Object)"Parsing abstract failed!", (Throwable)oops);
        }
    }

    private void generateTitle(HtmlDocument htmlDoc, DocBookTagFactory dbf, Info info) {
        ElementImpl elem = (ElementImpl)XPathServices.getNode(htmlDoc, "/html/head/title");
        if (elem == null) {
            for (int i = 1; i <= 6; ++i) {
                if (elem != null) continue;
                elem = (ElementImpl)XPathServices.getNode(htmlDoc, "/html/body/h" + i + "[1]");
            }
        }
        if (elem != null) {
            info.appendChild(dbf.createTitle(elem.getTextContent()));
        } else {
            Text text = (Text)XPathServices.getNode(htmlDoc, "//text()[1]");
            if (text != null) {
                info.appendChild(dbf.createTitle(text.getData()));
            } else {
                info.appendChild(dbf.createTitle("Herold"));
            }
        }
    }

    private String detectLanguage(Element documentElement) {
        HtmlElement elem;
        String lang = documentElement.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
        if (lang == null) {
            lang = documentElement.getAttribute("lang");
        }
        if (lang == null && (elem = (HtmlElement)XPathServices.getNode(documentElement, "//meta[@http-equiv='Content-Language']")) != null) {
            lang = elem.getAttribute("content");
        }
        return lang;
    }

    public void addProgressListeners(ArrayList<ProgressListener> newListeners) {
        if (newListeners == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.addAll(newListeners);
    }
}

