/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.dita.editor;

import org.dbdoclet.tag.dita.DitaTagFactory;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.tag.javadoc.JavaDocElement;
import org.dbdoclet.trafo.html.EditorFactoryException;
import org.dbdoclet.trafo.html.IEditor;
import org.dbdoclet.trafo.html.IEditorFactory;
import org.dbdoclet.trafo.html.dita.LinkManager;
import org.dbdoclet.trafo.html.dita.editor.CommentEditor;
import org.dbdoclet.trafo.html.dita.editor.DefaultEditor;
import org.dbdoclet.trafo.html.dita.editor.DitaEditor;
import org.dbdoclet.trafo.html.dita.editor.TextEditor;
import org.dbdoclet.trafo.script.Script;

public class DitaEditorFactory
implements IEditorFactory {
    private LinkManager linkManager;
    private DitaTagFactory tagFactory;

    @Override
    public IEditor getChildEditor(HtmlElement child) throws EditorFactoryException {
        Object o;
        if (child == null) {
            throw new EditorFactoryException("Can't create editor for child null!");
        }
        String str = child.getClass().getName();
        str = child instanceof JavaDocElement ? "org.dbdoclet.trafo.internal.html.dita.editor.javadoc" + str.substring(str.lastIndexOf(46), str.length()) + "Editor" : "org.dbdoclet.trafo.internal.html.dita.editor" + str.substring(str.lastIndexOf(46), str.length()) + "Editor";
        try {
            Class<?> c = Class.forName(str);
            o = c.newInstance();
            DitaEditor editor = (DitaEditor)o;
            editor.setLinkManager(this.linkManager);
            editor.setTagFactory(this.tagFactory);
        }
        catch (ClassNotFoundException oops) {
            DefaultEditor editor = new DefaultEditor();
            editor.setLinkManager(this.linkManager);
            editor.setTagFactory(this.tagFactory);
            return editor;
        }
        catch (InstantiationException oops) {
            throw new EditorFactoryException("Can't create editor for " + child.getNodeName());
        }
        catch (IllegalAccessException oops) {
            throw new EditorFactoryException("No permission to create editor for " + child.getNodeName());
        }
        return (IEditor)o;
    }

    @Override
    public IEditor getCommentEditor() {
        CommentEditor editor = new CommentEditor();
        editor.setLinkManager(this.linkManager);
        editor.setTagFactory(this.tagFactory);
        return editor;
    }

    @Override
    public IEditor getTextEditor() {
        TextEditor editor = new TextEditor();
        editor.setLinkManager(this.linkManager);
        editor.setTagFactory(this.tagFactory);
        return editor;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public void setScript(Script script) {
    }

    public void setTagFactory(DitaTagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }
}

