/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.dita.editor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.tag.dita.DitaElement;
import org.dbdoclet.tag.dita.DitaTagFactory;
import org.dbdoclet.tag.dita.P;
import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.Row;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.tag.html.Table;
import org.dbdoclet.tag.html.Td;
import org.dbdoclet.tag.html.Th;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.IEditor;
import org.dbdoclet.trafo.html.dita.DocumentElementType;
import org.dbdoclet.trafo.html.dita.LinkManager;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.xiphias.dom.CharacterDataImpl;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.dbdoclet.xiphias.dom.TextImpl;

public abstract class DitaEditor
implements IEditor {
    protected static final String FSEP = System.getProperty("file.separator");
    protected static final Log logger = LogFactory.getLog(DitaEditor.class);
    protected static final String AUTOMATICALLY_INSERTED = "Automatically inserted";
    private NodeImpl current;
    private NodeImpl parent;
    private HtmlElement child;
    private Object anything;
    private CharacterDataImpl characterDataNode;
    private boolean doIgnore;
    private boolean doTraverse;
    private LinkManager linkManager;
    private DocumentElementType documentElementType;
    private DitaTagFactory tagFactory;
    protected Script script;

    public void copyCommonAttributes(HtmlElement html, DitaElement ditaElement) {
        logger.debug((Object)("Copy common attributes from " + html + " to " + ditaElement));
        if (html == null || ditaElement == null) {
            return;
        }
        String htmlId = html.getId();
        if (htmlId != null) {
            if (this.linkManager != null) {
                ditaElement.setId(this.linkManager.createUniqueId(htmlId));
            } else {
                logger.warn((Object)("Attribute linkManager must not be null! " + html + ", " + this.toString()));
            }
        }
        if (this.script.isParameterOn("DocBook", "create-remap-attribute", false)) {
            this.createRemapAttribute(html, ditaElement);
            ditaElement.setLine(html.getLine());
            ditaElement.setColumn(html.getColumn());
        }
        ditaElement.setUserData("html", html, null);
    }

    protected void copyCommonAttributes(ElementImpl htmlElement, DocBookElement anchor) {
    }

    private void createRemapAttribute(HtmlElement html, DitaElement dbk) {
        String remap = String.format("%s:%d:%d", html.getTagName(), html.getLine(), html.getColumn());
        dbk.setRemap(remap);
    }

    @Override
    public EditorInstruction edit(EditorInstruction vo) throws EditorException {
        if (vo == null) {
            throw new IllegalArgumentException("Variable vo is null!");
        }
        this.setValues(vo);
        DitaTagFactory tagFactory = this.getTagFactory();
        if (this.parent instanceof Row) {
            P para;
            if (!(this.child == null || this.child instanceof Td || this.child instanceof Th || this.child instanceof Table)) {
                para = tagFactory.createP();
                this.current = this.parent = para;
            }
            if (this.characterDataNode != null && this.characterDataNode instanceof TextImpl) {
                para = tagFactory.createP();
                this.current = this.parent = para;
            }
        }
        return this.finalizeValues();
    }

    protected EditorInstruction finalizeValues() {
        EditorInstruction values = new EditorInstruction(this.script);
        values.doIgnore(this.doIgnore);
        values.doTraverse(this.doTraverse);
        values.setHtmlElement(this.child);
        values.setCurrent(this.current);
        values.setParent(this.parent);
        values.setCharacterDataNode(this.characterDataNode);
        return values;
    }

    public Object getAnything() {
        return this.anything;
    }

    public CharacterDataImpl getCharacterDataNode() {
        return this.characterDataNode;
    }

    public NodeImpl getCurrent() {
        return this.current;
    }

    public DocumentElementType getDocumentElementType() {
        return this.documentElementType;
    }

    public HtmlElement getHtmlElement() {
        return this.child;
    }

    public LinkManager getLinkManager() {
        return this.linkManager;
    }

    public NodeImpl getParent() {
        return this.parent;
    }

    @Override
    public DitaTagFactory getTagFactory() {
        if (this.tagFactory == null) {
            this.tagFactory = new DitaTagFactory();
        }
        return this.tagFactory;
    }

    public boolean ignore() {
        return this.doIgnore;
    }

    public void ignore(boolean newDoIgnore) {
        this.doIgnore = newDoIgnore;
    }

    public void setAnything(Object newAnything) {
        this.anything = newAnything;
    }

    public void setChild(HtmlElement newChild) {
        this.child = newChild;
    }

    public void setCurrent(NodeImpl current) {
        this.current = current;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public void setParent(NodeImpl newParent) {
        this.parent = newParent;
    }

    public void setTagFactory(DitaTagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }

    public void setTextNode(TextImpl newTextNode) {
        this.characterDataNode = newTextNode;
    }

    public void setValues(EditorInstruction values) {
        this.script = values.getScript();
        if (this.script == null) {
            throw new IllegalStateException("Der Parameter Script darf nicht null sein!");
        }
        this.child = values.getHtmlElement();
        this.current = values.getCurrent();
        this.doIgnore = values.doIgnore();
        this.doTraverse = values.doTraverse();
        this.parent = values.getParent();
        this.characterDataNode = values.getCharacterDataNode();
    }

    public String toString() {
        String buffer = "";
        buffer = buffer + "editor[" + this.getClass().getName() + "]";
        return buffer;
    }

    protected void transferId(HtmlElement html, DocBookElement db) {
        if (html == null) {
            throw new IllegalArgumentException("The argument html must not be null!");
        }
        if (db == null) {
            throw new IllegalArgumentException("The argument db must not be null!");
        }
        String id = html.getId();
        if (id != null && id.length() > 0) {
            db.setId(id);
        }
    }

    public boolean traverse() {
        return this.doTraverse;
    }

    public void traverse(boolean newDoTraverse) {
        this.doTraverse = newDoTraverse;
    }

    protected String validateAlign(String align) {
        return "left";
    }

    protected String validateSrc(String src) {
        if (src == null) {
            throw new IllegalArgumentException("Parameter src is null!");
        }
        if (src.startsWith("http:") && src.indexOf("?") > 0) {
            src = src.substring(0, src.indexOf("?"));
        }
        return src;
    }

    protected boolean isList(NodeImpl parentNode) {
        DocBookElement parent;
        return parentNode instanceof DocBookElement && (parent = (DocBookElement)parentNode).isList();
    }

    protected DitaElement getDitaElementParent() {
        NodeImpl parent = this.getParent();
        if (parent instanceof DitaElement) {
            return (DitaElement)parent;
        }
        return null;
    }

    protected boolean isSection(NodeImpl parentNode) {
        DocBookElement parent;
        return parentNode instanceof DocBookElement && (parent = (DocBookElement)parentNode).isSection();
    }

    protected boolean isContentModel(NodeImpl parentNode) {
        DitaElement parent;
        return parentNode instanceof DitaElement && (parent = (DitaElement)parentNode).isContentModel();
    }
}

