/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.dita.editor;

import org.dbdoclet.service.StringServices;
import org.dbdoclet.tag.dita.DitaElement;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.dita.editor.DitaEditor;
import org.dbdoclet.xiphias.XmlServices;
import org.dbdoclet.xiphias.dom.CharacterDataImpl;
import org.dbdoclet.xiphias.dom.CommentImpl;

public class CommentEditor
extends DitaEditor {
    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        try {
            this.setValues(super.edit(values));
            DitaElement parent = this.getDitaElementParent();
            CharacterDataImpl node = this.getCharacterDataNode();
            if (!(node instanceof CommentImpl)) {
                return this.finalizeValues();
            }
            CommentImpl comment = (CommentImpl)node;
            String text = comment.getData();
            if (text == null) {
                return this.finalizeValues();
            }
            text = text.trim();
            text = StringServices.cutPrefix(text, "<!--");
            text = StringServices.cutSuffix(text, "-->");
            text = text.trim();
            text = StringServices.cutPrefix(text, "[:dbdoclet:]");
            if ((text = text.trim()).startsWith("insert ")) {
                text = StringServices.cutPrefix(text, "insert");
                text = text.trim();
                text = XmlServices.textToXml(text);
                text = StringServices.replace(text, "(", "<");
                text = StringServices.replace(text, ")", ">");
                text = StringServices.replace(text, "<<", "(");
                text = StringServices.replace(text, ">>", ")");
                parent.appendChild(text, false);
            }
            return this.finalizeValues();
        }
        catch (Exception oops) {
            throw new EditorException(oops);
        }
    }
}

