/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.dita.editor;

import org.dbdoclet.service.StringServices;
import org.dbdoclet.tag.dita.DitaElement;
import org.dbdoclet.tag.dita.DitaTagFactory;
import org.dbdoclet.tag.dita.P;
import org.dbdoclet.tag.html.Br;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.dita.editor.DitaEditor;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.dbdoclet.xiphias.dom.TextImpl;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BrEditor
extends DitaEditor {
    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {
        this.setValues(super.edit(values));
        DitaTagFactory tagFactory = this.getTagFactory();
        this.traverse(false);
        Br brElement = (Br)values.getHtmlElement();
        Script script = values.getScript();
        boolean detectTrappedBrEnabled = script.isParameterOn("DocBook", "detect-trapped-br", true);
        if (detectTrappedBrEnabled && this.isTrapped(brElement, values.getCurrent())) {
            return this.finalizeValues();
        }
        if (this.getCurrent() instanceof P) {
            DitaElement parent = (DitaElement)this.getCurrent().getParentNode();
            if (parent != null) {
                P para = tagFactory.createP();
                parent.appendChild(para);
                this.setParent(para);
                this.setCurrent(para);
            }
        } else {
            this.getCurrent().appendChild(new TextImpl("\n"));
        }
        return this.finalizeValues();
    }

    private boolean isTrapped(Br brElement, NodeImpl nodeImpl) {
        Text lastChildText;
        String buffer;
        Node lastChild;
        Node prevSibling = brElement.getPreviousSibling();
        Node nextSibling = brElement.getNextSibling();
        if (prevSibling == null || nextSibling == null) {
            return false;
        }
        if (!(prevSibling instanceof Text) || !(nextSibling instanceof Text)) {
            return false;
        }
        String prevText = prevSibling.getTextContent();
        String nextText = nextSibling.getTextContent();
        if (prevText == null || nextText == null) {
            return false;
        }
        if (!nextText.matches("(?s)^[\\w\\u00A0].*$")) {
            return false;
        }
        if (!prevText.matches("(?s)^.*[\\w\\u00A0-]$")) {
            return false;
        }
        if (prevText.endsWith("-") && (lastChild = nodeImpl.getLastChild()) instanceof Text && (buffer = (lastChildText = (Text)lastChild).getTextContent()) != null && buffer.endsWith("-")) {
            buffer = StringServices.cutSuffix(buffer, "-");
            lastChildText.setTextContent(buffer);
        }
        return true;
    }
}

