/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.dita;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.jive.PanelProvider;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.progress.ProgressManager;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.tag.dita.DitaTagFactory;
import org.dbdoclet.tag.html.HtmlDocument;
import org.dbdoclet.tag.html.HtmlFragment;
import org.dbdoclet.trafo.AbstractTrafoService;
import org.dbdoclet.trafo.TrafoResult;
import org.dbdoclet.trafo.TrafoScriptManager;
import org.dbdoclet.trafo.html.HtmlProvider;
import org.dbdoclet.trafo.html.IHtmlVisitor;
import org.dbdoclet.trafo.html.dita.DitaVisitor;
import org.dbdoclet.trafo.html.dita.HtmlDitaPanel;
import org.dbdoclet.trafo.html.dita.PostprocessStage1;
import org.dbdoclet.trafo.html.dita.PostprocessStage2;
import org.dbdoclet.trafo.html.dita.PostprocessStage3;
import org.dbdoclet.trafo.html.dita.PreprocessStage1;
import org.dbdoclet.trafo.param.TextParam;
import org.dbdoclet.trafo.script.Namespace;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.trafo.script.ScriptEvent;
import org.dbdoclet.trafo.script.ScriptListener;
import org.dbdoclet.trafo.script.Section;
import org.dbdoclet.xiphias.NodeSerializer;
import org.dbdoclet.xiphias.dom.DocumentImpl;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeCountVisitor;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.osgi.service.component.ComponentContext;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class HtmlDitaTrafo
extends AbstractTrafoService
implements PanelProvider,
ScriptListener {
    private final Log logger = LogFactory.getLog(HtmlDitaTrafo.class);
    private HtmlDitaPanel htmlDitaPanel;
    private DitaTagFactory tagFactory = new DitaTagFactory();
    private Script script;
    private InputStream in;
    private OutputStream out;
    private ArrayList<ProgressListener> listeners = new ArrayList();

    protected void activate(ComponentContext context) {
        this.logger.info((Object)("Activierung des Bundles " + this.getId()));
    }

    @Override
    public String getId() {
        return "html2dita";
    }

    @Override
    public JPanel getPanel() {
        this.htmlDitaPanel = new HtmlDitaPanel();
        return this.htmlDitaPanel;
    }

    public Script getScript() {
        return this.script;
    }

    public DitaTagFactory getTagFactory() {
        return this.tagFactory;
    }

    @Override
    public void scriptChanged(ScriptEvent<?> event) {
        if (event.getType() == ScriptEvent.Type.INPUT_FILE_CHANGED) {
            System.out.println("Input File Changed");
        }
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setTagFactory(DitaTagFactory tagFactory) {
        if (tagFactory != null) {
            this.tagFactory = tagFactory;
        }
    }

    @Override
    public TrafoResult transform(Script script) {
        TrafoResult result = new TrafoResult();
        try {
            String encoding = script.getTextParameter("HTML", "encoding", "UTF-8");
            if (this.htmlDitaPanel != null) {
                String profileText;
                String profileName = this.htmlDitaPanel.getProfile();
                if (profileName != null && profileName.trim().length() > 0 && (profileText = ResourceServices.getResourceAsString("profiles/" + profileName + ".her", HtmlDitaTrafo.class.getClassLoader())) != null) {
                    TrafoScriptManager mgr = new TrafoScriptManager();
                    mgr.parseScript(script, profileText);
                }
                Namespace namespace = script.getNamespace();
                Section section = namespace.findSection("HTML");
                section.setParam(new TextParam("encoding", this.htmlDitaPanel.getSourceEncoding()));
                section = namespace.findSection("DocBook");
                section.setParam(new TextParam("language", this.htmlDitaPanel.getLanguage()));
                section.setParam(new TextParam("document-element", this.htmlDitaPanel.getDocumentType()));
            }
            DitaVisitor visitor = new DitaVisitor();
            visitor.addProgressListeners(this.listeners);
            visitor.setTagFactory(this.tagFactory);
            visitor.setScript(script);
            HtmlProvider htmlProvider = new HtmlProvider(script);
            NodeImpl htmlDoc = null;
            ElementImpl documentElement = null;
            String htmlCode = this.retrieveHtmlCode(this.in, encoding);
            boolean isFragment = htmlProvider.isFragment(htmlCode);
            htmlDoc = isFragment ? htmlProvider.parseFragment(htmlCode) : htmlProvider.parseDocument(htmlCode);
            ProgressManager pm = new ProgressManager(this.listeners);
            pm.nextStage();
            NodeCountVisitor nodeCounter = new NodeCountVisitor(this.listeners);
            htmlDoc.traverse(nodeCounter);
            pm.setProgressMaximum(nodeCounter.getNumberOfNodes());
            pm.fireProgressEvent(new ProgressEvent("Preprocess HTML tree...", false));
            PreprocessStage1 preprocessStage1 = new PreprocessStage1(this.listeners);
            htmlDoc.traverse(preprocessStage1);
            preprocessStage1.finish();
            pm.nextStage();
            pm.fireProgressEvent(new ProgressEvent("Transformation...", false));
            pm.setProgressMaximum(nodeCounter.getNumberOfNodes());
            if (isFragment) {
                DocumentFragment fragment = htmlProvider.traverse((HtmlFragment)htmlDoc, (IHtmlVisitor)visitor);
                documentElement = (ElementImpl)((Object)fragment);
            } else {
                Document document = htmlProvider.traverse((HtmlDocument)htmlDoc, (IHtmlVisitor)visitor);
                documentElement = (ElementImpl)document.getDocumentElement();
            }
            pm.nextStage();
            nodeCounter = new NodeCountVisitor(this.listeners);
            pm.fireProgressEvent(new ProgressEvent("Postprocess stage 1...", false));
            documentElement.traverse(nodeCounter);
            pm.setProgressMaximum(nodeCounter.getNumberOfNodes());
            PostprocessStage1 postprocessStage1 = new PostprocessStage1(this.tagFactory, script, this.listeners);
            documentElement.traverse(postprocessStage1);
            postprocessStage1.finish();
            pm.nextStage();
            pm.fireProgressEvent(new ProgressEvent("Postprocess stage 2...", false));
            documentElement.traverse(nodeCounter.reset());
            pm.setProgressMaximum(nodeCounter.getNumberOfNodes());
            PostprocessStage2 postprocessStage2 = new PostprocessStage2(this.tagFactory, script, this.listeners);
            documentElement.traverse(postprocessStage2);
            postprocessStage2.finish();
            new PostprocessStage3(this.tagFactory, postprocessStage1.getSubtables()).process();
            encoding = script.getTextParameter("DocBook", "encoding", "UTF-8");
            if (isFragment) {
                result.setRootNode(documentElement);
            } else {
                DocumentImpl document = documentElement.getDocument();
                document.setXmlEncoding(encoding);
                result.setRootNode(document);
            }
            if (this.out != null) {
                NodeSerializer serializer = new NodeSerializer();
                serializer.addProgressListeners(this.listeners);
                OutputStreamWriter writer = new OutputStreamWriter(this.out, encoding);
                if (isFragment) {
                    serializer.write((Node)documentElement, writer);
                } else {
                    DocumentImpl document = documentElement.getDocument();
                    document.setXmlEncoding(encoding);
                    serializer.write((Node)document, writer);
                }
                writer.close();
            }
        }
        catch (Throwable oops) {
            result.setThrowable(oops);
        }
        return result;
    }

    private String retrieveHtmlCode(InputStream in, String encoding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = in.read(buffer);
        while (n != -1) {
            out.write(buffer, 0, n);
            n = in.read(buffer);
        }
        in.close();
        out.close();
        return new String(out.toByteArray(), encoding);
    }

    @Override
    public void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }
}

