/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.dita;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.dbdoclet.Identifier;
import org.dbdoclet.jive.JiveFactory;
import org.dbdoclet.jive.widget.EncodingChooser;
import org.dbdoclet.jive.widget.GridPanel;
import org.dbdoclet.jive.widget.LanguageListBox;
import org.dbdoclet.service.ResourceServices;

public class HtmlDitaPanel
extends GridPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final EncodingChooser sourceEncodingChooser;
    private final LanguageListBox languageChooser;
    private final JCheckBox useAbsoluteImagePath;
    private final JComboBox<String> documentTypeComboBox;
    private final JComboBox<String> profileComboBox;
    private final JiveFactory jf;
    private final ResourceBundle res = ResourceBundle.getBundle("org/dbdoclet/trafo/html/docbook/Resources");

    public HtmlDitaPanel() {
        this.jf = JiveFactory.getInstance();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.sourceEncodingChooser = new EncodingChooser();
        this.sourceEncodingChooser.addActionListener(this.jf);
        this.addLabeledComponent(this.jf.createLabel(ResourceServices.getString(this.res, "C_ENCODING_SOURCE")), (JComponent)this.sourceEncodingChooser);
        this.incrRow();
        this.languageChooser = new LanguageListBox(Locale.getDefault());
        this.languageChooser.addActionListener(this.jf);
        this.addLabeledComponent(this.jf.createLabel(ResourceServices.getString(this.res, "C_LANGUAGE")), (JComponent)this.languageChooser);
        this.incrRow();
        this.useAbsoluteImagePath = this.jf.createCheckBox(new Identifier("use.absolute.imagepath"), ResourceServices.getString(this.res, "C_USE_ABSOLUTE_IMAGE_PATH"));
        this.addComponent(this.useAbsoluteImagePath);
        this.incrRow();
        String[] documentElementList = new String[]{"article", "book", "part"};
        this.documentTypeComboBox = this.jf.createComboBox(new Identifier("document.type"), documentElementList);
        this.documentTypeComboBox.addActionListener(this);
        this.addLabeledComponent(this.jf.createLabel(ResourceServices.getString(this.res, "C_DOCUMENT_ELEMENT")), this.documentTypeComboBox);
        String[] profileList = new String[]{"Default", "Word", "LibreOffice"};
        this.profileComboBox = this.jf.createComboBox(new Identifier("profile"), profileList);
        this.profileComboBox.addActionListener(this);
        this.addLabeledComponent(this.jf.createLabel(ResourceServices.getString(this.res, "C_PROFILE")), this.profileComboBox);
        this.leaveSubPanel();
        this.addVerticalGlue();
        this.languageChooser.setSelectedLocale(Locale.getDefault());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public String getSourceEncoding() {
        return this.sourceEncodingChooser.getEncoding();
    }

    public String getProfile() {
        Object selectedItem = this.profileComboBox.getSelectedItem();
        if (selectedItem == null) {
            return null;
        }
        return selectedItem.toString();
    }

    public String getLanguage() {
        return this.languageChooser.getSelectedLocale().getLanguage();
    }

    public Boolean useAbsoluteImagePath() {
        return this.useAbsoluteImagePath.isSelected();
    }

    public String getDocumentType() {
        return (String)this.documentTypeComboBox.getSelectedItem();
    }
}

