/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html.dita;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.tag.dita.Abstract;
import org.dbdoclet.tag.dita.DitaTagFactory;
import org.dbdoclet.tag.dita.Topic;
import org.dbdoclet.tag.docbook.BaseTagFactory;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.html.HtmlDocument;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.tag.html.HtmlFragment;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.IEditorFactory;
import org.dbdoclet.trafo.html.IHtmlVisitor;
import org.dbdoclet.trafo.html.dita.LinkManager;
import org.dbdoclet.trafo.html.dita.ListDetector;
import org.dbdoclet.trafo.html.dita.SectionDetector;
import org.dbdoclet.trafo.html.dita.editor.DitaEditorFactory;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.xiphias.XPathServices;
import org.dbdoclet.xiphias.dom.DocumentFragmentImpl;
import org.dbdoclet.xiphias.dom.DocumentImpl;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class DitaVisitor
implements IHtmlVisitor {
    private static Log logger = LogFactory.getLog(DitaVisitor.class);
    private ArrayList<ProgressListener> listeners;
    private LinkManager linkManager;
    private BaseTagFactory dbfactory = new DocBookTagFactory();
    private DitaTagFactory tagFactory;
    private Script script;
    private ListDetector listDetector = new ListDetector();
    private DitaEditorFactory editorFactory;

    public DitaVisitor() {
        this.linkManager = new LinkManager();
    }

    public void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    @Override
    public boolean beforeEdit(EditorInstruction values) {
        this.listDetector.edit(values, this.dbfactory);
        SectionDetector sectionDetector = new SectionDetector();
        sectionDetector.setScript(this.script);
        sectionDetector.setTagFactory(this.tagFactory);
        sectionDetector.setLinkManager(this.linkManager);
        HtmlElement htmlElement = values.getHtmlElement();
        if (sectionDetector.isSection(htmlElement)) {
            sectionDetector.edit(values);
            return false;
        }
        return true;
    }

    @Override
    public DocumentFragmentImpl createDocumentFragment(HtmlFragment htmlFragment) {
        DocumentFragmentImpl fragment = new DocumentFragmentImpl();
        return fragment;
    }

    @Override
    public DocumentImpl createDocument(HtmlDocument htmlDoc) {
        ElementImpl topic = this.createDocumentElement();
        DocumentImpl document = new DocumentImpl();
        String title = this.script.getTextParameter("DITA", "title", null);
        if (title != null && title.trim().length() > 0) {
            topic.appendChild(this.tagFactory.createTitle(title));
        } else {
            this.generateTitle(htmlDoc, this.tagFactory, topic);
        }
        String abstractText = this.script.getTextParameter("DocBook", "abstract", null);
        if (abstractText != null) {
            Abstract abstractElement = this.tagFactory.createAbstract();
            topic.appendChild(abstractElement);
            this.createAbstract(document, abstractElement, abstractText);
        }
        document.setDocumentElement(topic);
        topic.setDocument(document);
        return document;
    }

    private ElementImpl createDocumentElement() {
        Topic documentElement = this.tagFactory.createTopic();
        documentElement.setId("topic");
        String language = this.script.getTextParameter("DITA", "language", null);
        logger.debug((Object)("Profile: Parameter language = " + language));
        if (language == null) {
            language = this.detectLanguage(documentElement);
            logger.debug((Object)("Detected language from HTML = " + language));
            if (language == null) {
                language = Locale.getDefault().getLanguage().toLowerCase();
                logger.debug((Object)("Using default language from JVM = " + language));
            }
        }
        if (language != null) {
            documentElement.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", language);
        }
        return documentElement;
    }

    @Override
    public IEditorFactory getEditorFactory() {
        if (this.editorFactory == null) {
            this.editorFactory = new DitaEditorFactory();
            this.editorFactory.setLinkManager(this.linkManager);
            this.editorFactory.setScript(this.script);
            this.editorFactory.setTagFactory(this.tagFactory);
        }
        return this.editorFactory;
    }

    @Override
    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    public void setTagFactory(DitaTagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }

    private void createAbstract(Document doc, Abstract abstractElement, String abstractText) {
        abstractText = abstractText.trim().startsWith("<") ? "<abstract>" + abstractText + "</abstract>" : "<abstract><para>" + abstractText + "</para></abstract>";
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document docAbstract = documentBuilder.parse(new InputSource(new StringReader(abstractText)));
            Element documentElement = docAbstract.getDocumentElement();
            documentElement = (Element)doc.importNode(documentElement, true);
            if (documentElement != null && documentElement.hasChildNodes()) {
                NodeList childList = documentElement.getChildNodes();
                for (int i = 0; i < childList.getLength(); ++i) {
                    Node child = childList.item(i);
                    abstractElement.appendChild(child);
                }
            }
        }
        catch (Exception oops) {
            logger.error((Object)"Parsing abstract failed!", (Throwable)oops);
        }
    }

    private void generateTitle(HtmlDocument htmlDoc, DitaTagFactory dbf, ElementImpl parent) {
        ElementImpl elem = (ElementImpl)XPathServices.getNode(htmlDoc, "/html/head/title");
        if (elem == null) {
            for (int i = 1; i <= 6; ++i) {
                if (elem != null) continue;
                elem = (ElementImpl)XPathServices.getNode(htmlDoc, "/html/body/h" + i + "[1]");
            }
        }
        if (elem != null) {
            parent.appendChild(dbf.createTitle(elem.getTextContent()));
        } else {
            Text text = (Text)XPathServices.getNode(htmlDoc, "//text()[1]");
            if (text != null) {
                parent.appendChild(dbf.createTitle(text.getData()));
            } else {
                parent.appendChild(dbf.createTitle("Herold"));
            }
        }
    }

    private String detectLanguage(Element documentElement) {
        HtmlElement elem;
        String lang = documentElement.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
        if (lang == null) {
            lang = documentElement.getAttribute("lang");
        }
        if (lang == null && (elem = (HtmlElement)XPathServices.getNode(documentElement, "//meta[@http-equiv='Content-Language']")) != null) {
            lang = elem.getAttribute("content");
        }
        return lang;
    }

    public void addProgressListeners(ArrayList<ProgressListener> newListeners) {
        if (newListeners == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.addAll(newListeners);
    }
}

