/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.html.parser.HtmlParser;
import org.dbdoclet.html.parser.ParserException;
import org.dbdoclet.html.tokenizer.TokenizerException;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.progress.ProgressManager;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.tag.html.HtmlDocument;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.tag.html.HtmlFragment;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorFactoryException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.IEditor;
import org.dbdoclet.trafo.html.IEditorFactory;
import org.dbdoclet.trafo.html.IHtmlProvider;
import org.dbdoclet.trafo.html.IHtmlVisitor;
import org.dbdoclet.trafo.param.TextParam;
import org.dbdoclet.trafo.script.AttributeRule;
import org.dbdoclet.trafo.script.Namespace;
import org.dbdoclet.trafo.script.NodeRule;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.trafo.script.Section;
import org.dbdoclet.xiphias.XPathServices;
import org.dbdoclet.xiphias.annotation.MapToAttributeAnnotation;
import org.dbdoclet.xiphias.annotation.MapToNodeAnnotation;
import org.dbdoclet.xiphias.dom.CommentImpl;
import org.dbdoclet.xiphias.dom.DocumentFragmentImpl;
import org.dbdoclet.xiphias.dom.DocumentImpl;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.dbdoclet.xiphias.dom.NodeListImpl;
import org.dbdoclet.xiphias.dom.TextImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class HtmlProvider
implements IHtmlProvider {
    private static Log logger = LogFactory.getLog(HtmlProvider.class);
    public ArrayList<ProgressListener> listeners;
    private IEditorFactory editorFactory;
    private String indent = "";
    private ProgressManager pm;
    private Script script;
    private IHtmlVisitor visitor;

    public HtmlProvider(Script script) {
        this.script = script;
        this.listeners = new ArrayList();
        this.pm = new ProgressManager(this.listeners);
    }

    public boolean isFragment(String htmlCode) throws IOException, TokenizerException {
        HtmlParser parser = new HtmlParser();
        return parser.isFragment(htmlCode);
    }

    @Override
    public HtmlDocument parseDocument(String htmlCode) throws IOException, ParserException, TokenizerException {
        HtmlParser parser = new HtmlParser();
        if (this.listeners != null && this.listeners.size() > 0) {
            parser.addProgressListener(this.listeners.get(0));
        }
        HtmlDocument htmlDocument = parser.parseDocument(htmlCode);
        ElementImpl documentElement = (ElementImpl)htmlDocument.getDocumentElement();
        documentElement.removeAttribute("xmlns");
        this.parseAfter(documentElement);
        return htmlDocument;
    }

    @Override
    public HtmlFragment parseFragment(String htmlCode) throws IOException, ParserException, TokenizerException {
        HtmlParser parser = new HtmlParser();
        if (this.listeners != null && this.listeners.size() > 0) {
            parser.addProgressListener(this.listeners.get(0));
        }
        HtmlFragment htmlFragment = parser.parseFragment(htmlCode);
        this.parseAfter(htmlFragment);
        return htmlFragment;
    }

    @Override
    public void setProgressListeners(ArrayList<ProgressListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public Document traverse(HtmlDocument htmlDocument, IHtmlVisitor visitor) throws Exception {
        this.visitor = visitor;
        if (htmlDocument == null) {
            return null;
        }
        this.editorFactory = visitor.getEditorFactory();
        DocumentImpl doc = visitor.createDocument(htmlDocument);
        this.edit((ElementImpl)htmlDocument.getDocumentElement(), (ElementImpl)doc.getDocumentElement());
        return doc;
    }

    @Override
    public DocumentFragment traverse(HtmlFragment htmlFragment, IHtmlVisitor visitor) {
        this.visitor = visitor;
        if (htmlFragment == null) {
            return null;
        }
        this.editorFactory = visitor.getEditorFactory();
        DocumentFragmentImpl fragment = visitor.createDocumentFragment(htmlFragment);
        this.edit(htmlFragment, fragment);
        return fragment;
    }

    private void afterEdit(EditorInstruction values) {
    }

    private boolean beforeEdit(EditorInstruction values) {
        return this.visitor.beforeEdit(values);
    }

    private NodeImpl edit(NodeImpl htmlNode, NodeImpl targetNode) {
        logger.debug((Object)("-> edit " + htmlNode));
        if (htmlNode == null) {
            logger.error((Object)"[DocBookDoclet.edit] - Parameter node is null!");
            return null;
        }
        if (targetNode == null) {
            logger.error((Object)"[DocBookDoclet.edit] - Parameter dbParent is null!");
            return null;
        }
        NodeListImpl htmlChildren = htmlNode.getTrafoChildNodes();
        Iterator<NodeImpl> iterator = htmlChildren.iterator();
        boolean doTraverse = true;
        boolean doIgnore = false;
        NodeImpl child = null;
        NodeImpl oldParent = targetNode;
        logger.debug((Object)(this.indent + "\n>>>=================================================="));
        logger.debug((Object)(this.indent + " HTML Vaterelement " + htmlNode + "."));
        logger.debug((Object)(this.indent + " DocBook Vaterelement " + targetNode + "."));
        this.indent = this.indent + ".";
        while (iterator.hasNext()) {
            child = iterator.next();
            this.pm.fireProgressEvent(new ProgressEvent("Transforming " + child.toString()));
            logger.debug((Object)(this.indent + " HTML element is " + child + "."));
            NodeImpl element = targetNode;
            doTraverse = true;
            EditorInstruction editorInstruction = null;
            if (child instanceof CommentImpl) {
                editorInstruction = this.editComment(child, targetNode);
            }
            if (child instanceof TextImpl) {
                editorInstruction = this.editText(child, targetNode);
            }
            if (child instanceof HtmlElement) {
                editorInstruction = this.editElement(child, targetNode);
            }
            if (editorInstruction == null) continue;
            element = editorInstruction.getCurrent();
            doTraverse = editorInstruction.doTraverse();
            doIgnore = editorInstruction.doIgnore();
            targetNode = editorInstruction.getParent();
            if (targetNode == null) {
                throw new NullPointerException("[Node] DocBook parent element for element " + child + " is null!");
            }
            if (doTraverse) {
                NodeImpl childParent = this.edit(child, element);
                logger.debug((Object)(this.indent + "\n<<<=================================================="));
                if (doIgnore) {
                    targetNode = childParent;
                }
            } else {
                int num = HtmlParser.computeSize(child);
                for (int i = 0; i < num; ++i) {
                    this.pm.fireProgressEvent(new ProgressEvent("Transforming node " + htmlNode.getNodeName()));
                }
            }
            logger.debug((Object)(this.indent + "[Teilbaum bearbeitet] HTML: " + child + ", DocBook: " + element + ", Vater: " + targetNode));
            if (targetNode == oldParent) continue;
            logger.debug((Object)(this.indent + "Parent changed. Old parent was " + oldParent + ". New parent is " + targetNode + "."));
            NodeImpl dbelem = oldParent;
            logger.debug((Object)(this.indent + "Closing old parent " + dbelem + ". HTML Element is " + child + "."));
            oldParent = targetNode;
        }
        if (this.indent.length() > 2) {
            this.indent = this.indent.substring(0, this.indent.length() - 2);
        }
        logger.debug((Object)(this.indent + "[Vaterknoten bearbeitet] HTML: " + child + ", Vaterknoten: " + targetNode));
        logger.debug((Object)"<- edit ");
        return targetNode;
    }

    private EditorInstruction editComment(NodeImpl child, NodeImpl targetNode) {
        try {
            CommentImpl comment = (CommentImpl)child;
            if (this.isInstruction(comment)) {
                EditorInstruction values = new EditorInstruction(this.visitor.getScript());
                values.setHtmlElement(null);
                values.setCurrent(targetNode);
                values.setParent(targetNode);
                values.setCharacterDataNode((CommentImpl)child);
                IEditor editor = this.editorFactory.getCommentEditor();
                logger.debug((Object)(this.indent + " Vor der Kommentarbearbeitung: " + child + ".\n"));
                values = editor.edit(values);
                logger.debug((Object)(this.indent + " Nach der Kommentarbearbeitung: " + child + ".\n"));
                targetNode = values.getParent();
                if (targetNode == null) {
                    throw new NullPointerException("[Node]DocBook parent element for element '" + child + "' is null!");
                }
                return values;
            }
            this.pm.fireProgressEvent(new ProgressEvent("Comment"));
            targetNode.appendChild(child);
            return null;
        }
        catch (EditorException oops) {
            logger.debug((Object)(this.indent + " EditorException " + oops.getMessage()));
            return null;
        }
    }

    private EditorInstruction editElement(NodeImpl child, NodeImpl targetNode) {
        try {
            HtmlElement htmlElement = (HtmlElement)child;
            IEditor editor = this.editorFactory.getChildEditor(htmlElement);
            logger.debug((Object)"Setting editor values.");
            EditorInstruction values = new EditorInstruction(this.visitor.getScript());
            values.setHtmlElement((HtmlElement)child);
            values.setCurrent(targetNode);
            values.setParent(targetNode);
            values.setCharacterDataNode(null);
            logger.debug((Object)(this.indent + " Vor der Transformation: " + child + ".\n" + "Editor " + editor + "\n" + values));
            MapToNodeAnnotation mapToAnnotation = child.getAnnotation(MapToNodeAnnotation.class);
            if (mapToAnnotation != null) {
                NodeImpl parent = values.getParent();
                String mapTo = mapToAnnotation.getMapTo();
                Element mapToElement = editor.getTagFactory().createElement(mapTo);
                parent.appendChild(mapToElement);
                values.setCurrent((ElementImpl)mapToElement);
            } else if (this.beforeEdit(values)) {
                values = editor.edit(values);
                this.afterEdit(values);
            }
            NodeImpl current = values.getCurrent();
            List<MapToAttributeAnnotation> mapToAttributeList = child.getAnnotations(MapToAttributeAnnotation.class);
            mapToAttributeList.stream().forEach(annotation -> {
                String attrValue = htmlElement.getAttribute(annotation.getAttribute());
                if (attrValue != null && current != null && current instanceof Element) {
                    ((Element)((Object)current)).setAttribute(annotation.getMapTo(), attrValue);
                }
            });
            logger.debug((Object)(this.indent + " Nach der Transformation: " + child + ".\n" + "Editor " + editor + "\n" + values));
            return values;
        }
        catch (EditorFactoryException oops) {
            logger.fatal((Object)"EditorFactoryException", (Throwable)oops);
        }
        catch (EditorException oops) {
            logger.fatal((Object)"EditorException", (Throwable)oops);
        }
        return null;
    }

    private EditorInstruction editText(NodeImpl child, NodeImpl targetNode) {
        logger.debug((Object)("Text='" + ((Text)((Object)child)).toString() + "'"));
        try {
            EditorInstruction values = new EditorInstruction(this.visitor.getScript());
            values.setHtmlElement(null);
            values.setCurrent(targetNode);
            values.setParent(targetNode);
            values.setCharacterDataNode((TextImpl)child);
            IEditor editor = this.editorFactory.getTextEditor();
            logger.debug((Object)(this.indent + " Vor der Textbearbeitung: " + child + ".\n"));
            values = editor.edit(values);
            logger.debug((Object)(this.indent + " Nach der Textbearbeitung: " + child + ".\n"));
            targetNode = values.getParent();
            if (targetNode == null) {
                throw new NullPointerException("[Node] DocBook parent element for element '" + child + "' is null!");
            }
            return values;
        }
        catch (EditorException oops) {
            logger.fatal((Object)"EditorException", (Throwable)oops);
            return null;
        }
    }

    private boolean isInstruction(CommentImpl comment) {
        if (comment == null) {
            return false;
        }
        String text = comment.getData();
        if (text == null) {
            return false;
        }
        text = text.trim();
        text = StringServices.cutPrefix(text, "<!--");
        text = StringServices.cutSuffix(text, "-->");
        return (text = text.trim()).startsWith("[:dbdoclet:]");
    }

    private void parseAfter(NodeImpl contextNode) {
        ArrayList<Node> nodes;
        String xpath;
        TextParam excludeParam;
        Namespace namespace = this.script.getNamespace();
        Section section = namespace.findSection("HTML");
        if (section != null && (excludeParam = section.findTextParameter("exclude")) != null) {
            for (String excludeXpath : excludeParam.getValues()) {
                ArrayList<Node> nodeList = XPathServices.getNodes(contextNode, excludeXpath);
                for (Node node : nodeList) {
                    if (node.getParentNode() == null) continue;
                    node.getParentNode().removeChild(node);
                }
            }
        }
        for (NodeRule nodeRule : namespace.getNodeRules()) {
            xpath = nodeRule.getName();
            nodes = XPathServices.getNodes(contextNode, xpath);
            for (Node node : nodes) {
                if (!(node instanceof HtmlElement)) continue;
                HtmlElement htmlElement = (HtmlElement)node;
                TextParam paramMapTo = nodeRule.findTextParameter("map-to");
                MapToNodeAnnotation annotation = new MapToNodeAnnotation();
                annotation.setMapTo((String)paramMapTo.getValue());
                htmlElement.addAnnotation(annotation);
            }
        }
        for (AttributeRule attributeRule : namespace.getAttributeRules()) {
            xpath = attributeRule.getName();
            nodes = XPathServices.getNodes(contextNode, xpath);
            for (Node node : nodes) {
                if (!(node instanceof Attr)) continue;
                Attr attribute = (Attr)node;
                HtmlElement htmlElement = (HtmlElement)attribute.getOwnerElement();
                TextParam paramMapTo = attributeRule.findTextParameter("map-to");
                MapToAttributeAnnotation annotation = new MapToAttributeAnnotation();
                annotation.setMapTo((String)paramMapTo.getValue());
                annotation.setAttribute(attribute.getName());
                htmlElement.addAnnotation(annotation);
            }
        }
    }
}

