/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.dbdoclet.trafo.TrafoException;
import org.dbdoclet.trafo.param.Param;
import org.dbdoclet.trafo.script.AttributeRule;
import org.dbdoclet.trafo.script.Namespace;
import org.dbdoclet.trafo.script.NodeRule;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.trafo.script.Section;
import org.dbdoclet.trafo.script.parser.TrafoScriptLexer;
import org.dbdoclet.trafo.script.parser.TrafoScriptListenerImpl;
import org.dbdoclet.trafo.script.parser.TrafoScriptParser;
import org.dbdoclet.trafo.script.parser.TrafoScriptParserErrorListener;

public class TrafoScriptManager {
    public Script parseScript(File scriptFile) throws TrafoException {
        Script script = new Script();
        this.parseScript(script, scriptFile, "");
        return script;
    }

    public void parseScript(Script script, File scriptFile) throws TrafoException {
        this.parseScript(script, scriptFile, "");
    }

    public void parseScript(Script script, File scriptFile, String namespace) throws TrafoException {
        try {
            TrafoScriptLexer lex = new TrafoScriptLexer((CharStream)new ANTLRFileStream(scriptFile.getAbsolutePath(), "UTF8"));
            this.parseScript(script, lex, namespace);
        }
        catch (Exception oops) {
            throw new TrafoException(oops);
        }
    }

    public void parseScript(Script script, InputStream instr, String namespace) throws TrafoException {
        try {
            TrafoScriptLexer lex = new TrafoScriptLexer((CharStream)new ANTLRInputStream(instr));
            this.parseScript(script, lex, namespace);
        }
        catch (Exception oops) {
            throw new TrafoException(oops);
        }
    }

    public Script parseScript(String scriptBuffer) throws IOException, RecognitionException, TrafoException {
        TrafoScriptLexer lex = new TrafoScriptLexer((CharStream)new ANTLRInputStream(scriptBuffer));
        Script script = new Script();
        this.parseScript(script, lex, "");
        return script;
    }

    private Script parseScript(Script script, TrafoScriptLexer lex, String namespace) throws RecognitionException, TrafoException {
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        TrafoScriptParser parser = new TrafoScriptParser((TokenStream)tokens);
        parser.removeErrorListeners();
        TrafoScriptParserErrorListener errorListener = new TrafoScriptParserErrorListener();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        TrafoScriptParser.ParseContext parserTree = parser.parse();
        List<String> errors = errorListener.getErrors();
        if (errors != null && errors.size() > 0) {
            throw new TrafoException(errors.get(0));
        }
        ParseTreeWalker walker = new ParseTreeWalker();
        TrafoScriptListenerImpl listener = new TrafoScriptListenerImpl(script, namespace);
        walker.walk((ParseTreeListener)listener, (ParseTree)parserTree);
        return script;
    }

    public void parseScript(Script script, String scriptBuffer) throws TrafoException {
        try {
            TrafoScriptLexer lex = new TrafoScriptLexer((CharStream)new ANTLRInputStream(scriptBuffer));
            this.parseScript(script, lex, "");
        }
        catch (Exception oops) {
            throw new TrafoException(oops);
        }
    }

    public void writeScript(Script script, File file) throws IOException {
        this.writeScript("", script, file);
    }

    public void writeScript(String namespace, Script script, File file) throws IOException {
        this.writeScript(namespace, script, new FileWriter(file));
    }

    public void writeScript(Script script, Writer writer) throws IOException {
        this.writeScript("", script, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeScript(String namespaceName, Script script, Writer writer) throws IOException {
        try (PrintWriter printWriter = null;){
            printWriter = new PrintWriter(writer);
            String transformationName = "trafo";
            Param<?> sysparam = script.getSystemParameter(namespaceName, "transformation.name");
            if (sysparam != null) {
                transformationName = (String)sysparam.getValue();
            }
            printWriter.println(String.format("transformation %s;", transformationName));
            Namespace namespace = script.getNamespace(namespaceName);
            if (namespace == null) {
                return;
            }
            for (Section section : namespace.getSections()) {
                if (section.getName().startsWith("SYS ")) continue;
                printWriter.println(String.format("%nsection %s {", section.getName()));
                for (Param<?> param : section.getParameters()) {
                    printWriter.println(String.format("\t%s;", param.toString()));
                }
                printWriter.println("}");
            }
            for (NodeRule nodeRule : namespace.getNodeRules()) {
                printWriter.println(String.format("%nnode %s {", nodeRule.getName()));
                for (Param<?> param : nodeRule.getParameters()) {
                    printWriter.println(String.format("\t%s;", param.toString()));
                }
                printWriter.println("}");
            }
            for (AttributeRule attributeRule : namespace.getAttributeRules()) {
                printWriter.println(String.format("%nattribute %s {", attributeRule.getName()));
                for (Param<?> param : attributeRule.getParameters()) {
                    printWriter.println(String.format("\t%s;", param.toString()));
                }
                printWriter.println("}");
            }
        }
    }

    public void mergeNamespaces(Script script) {
        script.mergeNamespaces();
    }
}

