/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.xiphias.dom.NodeImpl;

public class TrafoResult
implements ErrorListener {
    private File file;
    private StringBuffer buffer;
    private byte[] data;
    private Throwable throwable;
    private boolean failed = false;
    private NodeImpl rootNode;

    public TrafoResult() {
        this.buffer = new StringBuffer();
    }

    public TrafoResult(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        this.file = file;
        this.buffer = new StringBuffer();
    }

    public void append(String line) {
        this.buffer.append(line);
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        this.buffer.append("[error] " + exception.getMessage());
        this.buffer.append('\n');
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        this.buffer.append("[fatal] " + exception.getMessage());
        this.buffer.append('\n');
        this.failed = true;
    }

    public String getBuffer() {
        return this.buffer.toString();
    }

    public byte[] getData() {
        return this.data;
    }

    public File getFile() {
        return this.file;
    }

    public NodeImpl getRootNode() {
        return this.rootNode;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setRootNode(NodeImpl rootNode) {
        this.rootNode = rootNode;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
        if (throwable != null) {
            this.failed = true;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        builder.append(StringServices.createBox("TRANSFORMATION PROTOCOL"));
        if (this.buffer != null) {
            builder.append("=== STDOUT/STDERR ===\n");
            builder.append(this.buffer);
        }
        if (this.throwable != null) {
            if (this.throwable instanceof FileNotFoundException) {
                builder.append("[ERROR] File not found: " + this.throwable.getMessage());
            } else {
                builder.append("\n=== EXCEPTION ===\n");
                StringWriter strBuffer = new StringWriter();
                this.throwable.printStackTrace(new PrintWriter(strBuffer));
                builder.append(strBuffer.toString());
            }
        }
        builder.append(">>TRANSFORMATION FINISHED.\n\n");
        return builder.toString();
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        this.buffer.append(exception.getMessage());
        this.buffer.append('\n');
    }
}

