/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.progress.ConsoleProgressListener;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.trafo.ScriptService;
import org.dbdoclet.trafo.TrafoResult;
import org.dbdoclet.trafo.TrafoScriptManager;
import org.dbdoclet.trafo.TrafoService;
import org.dbdoclet.trafo.script.Script;
import org.osgi.service.component.ComponentContext;

public class TrafoComponent
implements ScriptService {
    private static final Log logger = LogFactory.getLog(TrafoComponent.class);
    private final HashMap<String, ArrayList<TrafoService>> trafoServiceMap = new HashMap();

    public void addTrafoService(TrafoService trafoService) {
        ArrayList<TrafoService> trafoServiceList;
        String category = trafoService.getId();
        if (category == null) {
            category = "";
        }
        if ((trafoServiceList = this.trafoServiceMap.get(category)) == null) {
            trafoServiceList = new ArrayList();
            this.trafoServiceMap.put(category, trafoServiceList);
        }
        trafoServiceList.add(trafoService);
        logger.info((Object)("Neuer TrafoService " + trafoService.getId()));
    }

    @Override
    public TrafoResult executeTrafoScript(File scriptFile, ProgressListener listener) {
        TrafoResult result = new TrafoResult();
        try {
            TrafoScriptManager mgr = new TrafoScriptManager();
            Script script = mgr.parseScript(scriptFile);
            String type = script.getInputFormat() + "2" + script.getOutputFormat();
            ArrayList<TrafoService> trafoServiceList = this.trafoServiceMap.get(type);
            if (trafoServiceList == null || trafoServiceList.size() == 0) {
                result.append(String.format("[Error] Can't find TrafoService for transformation type %s!", type));
                return result;
            }
            TrafoService trafo = trafoServiceList.get(0);
            trafo.addProgressListener(listener);
            return trafo.transform(script);
        }
        catch (Throwable oops) {
            result.setThrowable(oops);
            return result;
        }
    }

    public ArrayList<TrafoService> getTrafoServiceList() {
        ArrayList<TrafoService> trafoServiceList = new ArrayList<TrafoService>();
        for (ArrayList<TrafoService> list : this.trafoServiceMap.values()) {
            trafoServiceList.addAll(list);
        }
        return trafoServiceList;
    }

    public List<TrafoService> getTrafoServiceList(String category) {
        if (category == null) {
            category = "";
        }
        return this.trafoServiceMap.get(category);
    }

    public void removeTrafoService(TrafoService trafoService) {
        ArrayList<TrafoService> trafoServiceList;
        String category = trafoService.getId();
        if (category == null) {
            category = "";
        }
        if ((trafoServiceList = this.trafoServiceMap.get(category)) != null) {
            trafoServiceList.remove(trafoService);
            logger.info((Object)("Entferne TrafoService " + trafoService.getId()));
        }
    }

    protected void activate(ComponentContext context) {
        logger.info((Object)"Activating Service Trafo...");
        String trnPath = System.getProperty("trafo.script");
        if (trnPath != null) {
            TrafoResult result = this.executeTrafoScript(new File(trnPath), new ConsoleProgressListener());
            if (result != null) {
                System.out.println(result.toString());
            } else {
                System.out.println("NO RESULT!!!");
            }
        }
    }

    protected void deactivate(ComponentContext context) {
        logger.info((Object)"Tidbit Deaktivierung");
    }
}

