/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.template;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.template.TemplateTransformException;

public class TemplateTransformer {
    private BufferedReader reader;

    public static TemplateTransformer newInstance(File template) throws TemplateTransformException {
        if (template == null) {
            throw new IllegalArgumentException("The argument template may not be null!");
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(template));
        }
        catch (IOException oops) {
            throw new TemplateTransformException(oops.getMessage(), oops);
        }
        return new TemplateTransformer(reader);
    }

    public static TemplateTransformer newInstance(BufferedReader template) throws TemplateTransformException {
        if (template == null) {
            throw new IllegalArgumentException("The argument template may not be null!");
        }
        return new TemplateTransformer(template);
    }

    public static TemplateTransformer newInstance(String template) throws TemplateTransformException {
        if (template == null) {
            throw new IllegalArgumentException("The argument template may not be null!");
        }
        return new TemplateTransformer(new BufferedReader(new StringReader(template)));
    }

    private TemplateTransformer(BufferedReader reader) {
        this.reader = reader;
    }

    public String transform(Map<String, String> vars) throws TemplateTransformException {
        StringWriter buffer = new StringWriter();
        this.transform(vars, new PrintWriter(buffer));
        return buffer.toString();
    }

    public void transform(Map<String, String> vars, String fileName) throws TemplateTransformException {
        if (fileName == null) {
            throw new IllegalArgumentException("The argument fileName must not be null!");
        }
        this.transform(vars, new File(fileName));
    }

    public void transform(Map<String, String> vars, File file) throws TemplateTransformException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        try {
            this.transform(vars, new FileWriter(file));
        }
        catch (IOException oops) {
            throw new TemplateTransformException(oops.getMessage(), oops);
        }
    }

    public void transform(Map<String, String> vars, FileWriter fileWriter) throws TemplateTransformException {
        if (fileWriter == null) {
            throw new IllegalArgumentException("The argument fileWriter must not be null!");
        }
        PrintWriter writer = new PrintWriter(fileWriter);
        this.transform(vars, writer);
        writer.close();
    }

    public void transform(Map<String, String> vars, PrintWriter writer) throws TemplateTransformException {
        if (this.reader == null) {
            throw new IllegalStateException("The field reader may not be null!");
        }
        if (vars == null) {
            throw new IllegalArgumentException("The argument vars may not be null!");
        }
        if (writer == null) {
            throw new IllegalArgumentException("The argument writer may not be null!");
        }
        try {
            String line;
            StringBuffer buffer = new StringBuffer();
            while ((line = this.reader.readLine()) != null) {
                if (line.trim().length() == 0) {
                    buffer.append(line);
                    buffer.append('\n');
                    continue;
                }
                if (line.indexOf(36) == -1) {
                    buffer.append(line);
                    buffer.append('\n');
                    continue;
                }
                for (String name : vars.keySet()) {
                    String value = vars.get(name);
                    if (value == null) continue;
                    name = "${" + name + "}";
                    line = StringServices.replace(line, name, value.toString());
                }
                buffer.append(line);
                buffer.append('\n');
            }
            this.reader.close();
            String str = buffer.toString();
            BufferedReader bufferReader = new BufferedReader(new StringReader(str));
            while ((line = bufferReader.readLine()) != null) {
                writer.println(line);
            }
            bufferReader.close();
        }
        catch (Exception oops) {
            throw new TemplateTransformException(oops.getMessage(), oops);
        }
    }
}

