/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.tag.html;

import java.util.HashMap;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.tag.html.StrictElement;
import org.dbdoclet.tag.html.Table;
import org.dbdoclet.tag.html.TableColumnElement;
import org.dbdoclet.tag.html.Tbody;
import org.dbdoclet.tag.html.Td;
import org.dbdoclet.tag.html.Tfoot;
import org.dbdoclet.tag.html.Thead;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;

public class Tr
extends StrictElement {
    private static String tagName = "tr";
    private static HashMap<String, HashMap<String, String>> validParentMap = new HashMap();

    public static String getTag() {
        return tagName;
    }

    public Tr() {
        this.setNodeName(tagName);
        this.setFormatType(3);
    }

    @Override
    public void closed() {
        boolean hasColumns = false;
        if (this.hasChildNodes() && this.getNumberOfChildNodes() > 0) {
            for (NodeImpl node : this.getTrafoChildNodes()) {
                ElementImpl elem;
                if (!(node instanceof HtmlElement) || !((elem = (ElementImpl)node) instanceof TableColumnElement)) continue;
                hasColumns = true;
            }
        }
        if (!hasColumns) {
            this.appendChild(new Td());
        }
    }

    @Override
    public void init() {
    }

    @Override
    public boolean validateAttributes() {
        String valign = this.getAttribute("valign");
        if (!(valign == null || valign.equalsIgnoreCase("top") || valign.equalsIgnoreCase("middle") || valign.equalsIgnoreCase("bottom") || valign.equalsIgnoreCase("baseline"))) {
            this.setAttribute("valign", "middle");
        }
        return true;
    }

    public Integer getHeight() {
        return this.getIntAttribute("height");
    }

    static {
        validParentMap.put(Table.getTag(), HtmlElement.getAttributeMap());
        validParentMap.put(Tbody.getTag(), HtmlElement.getAttributeMap());
        validParentMap.put(Thead.getTag(), HtmlElement.getAttributeMap());
        validParentMap.put(Tfoot.getTag(), HtmlElement.getAttributeMap());
    }
}

