/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.tag.html;

import org.dbdoclet.tag.html.StrictElement;

public abstract class TableColumnElement
extends StrictElement {
    private int index = -1;

    public String getWidth() {
        String width = this.getAttribute("width");
        if (width == null || width.length() == 0) {
            return "";
        }
        return width;
    }

    public int getColspan() {
        int colspan;
        String str = this.getAttribute("colspan");
        if (str == null || str.length() == 0) {
            return 1;
        }
        try {
            colspan = Integer.parseInt(str);
        }
        catch (NumberFormatException oops) {
            colspan = 1;
        }
        return colspan;
    }

    public int getRowspan() {
        int rowspan;
        String str = this.getAttribute("rowspan");
        if (str == null || str.length() == 0) {
            return 0;
        }
        try {
            rowspan = Integer.parseInt(str);
            --rowspan;
        }
        catch (NumberFormatException oops) {
            rowspan = 0;
        }
        if (rowspan < 0) {
            rowspan = 0;
        }
        return rowspan;
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public String getVAlign() {
        String valign = this.getAttribute("valign");
        if (valign == null || valign.length() == 0) {
            return null;
        }
        if (valign.equalsIgnoreCase("top") || valign.equalsIgnoreCase("middle") || valign.equalsIgnoreCase("bottom") || valign.equalsIgnoreCase("baseline")) {
            return valign;
        }
        if (valign.equalsIgnoreCase("head")) {
            return "top";
        }
        return "middle";
    }

    public String getChar() {
        return this.getAttribute("char");
    }

    public String getCharOff() {
        return this.getAttribute("charoff");
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean validateAttributes() {
        String valign = this.getVAlign();
        if (valign != null) {
            this.setAttribute("valign", valign);
        }
        return true;
    }
}

