/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.tag.html;

import java.util.ArrayList;
import java.util.HashMap;
import org.dbdoclet.tag.html.Applet;
import org.dbdoclet.tag.html.Blockquote;
import org.dbdoclet.tag.html.Body;
import org.dbdoclet.tag.html.Button;
import org.dbdoclet.tag.html.Caption;
import org.dbdoclet.tag.html.Center;
import org.dbdoclet.tag.html.Dd;
import org.dbdoclet.tag.html.Del;
import org.dbdoclet.tag.html.Div;
import org.dbdoclet.tag.html.Fieldset;
import org.dbdoclet.tag.html.Form;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.tag.html.HtmlObject;
import org.dbdoclet.tag.html.Iframe;
import org.dbdoclet.tag.html.Inline2Element;
import org.dbdoclet.tag.html.Ins;
import org.dbdoclet.tag.html.Li;
import org.dbdoclet.tag.html.Map;
import org.dbdoclet.tag.html.Noframes;
import org.dbdoclet.tag.html.Noscript;
import org.dbdoclet.tag.html.TableColumnElement;
import org.dbdoclet.tag.html.Tbody;
import org.dbdoclet.tag.html.Td;
import org.dbdoclet.tag.html.Tfoot;
import org.dbdoclet.tag.html.Th;
import org.dbdoclet.tag.html.Thead;
import org.dbdoclet.tag.html.Tr;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.dbdoclet.xiphias.dom.NodeListImpl;

public class Table
extends Inline2Element {
    private static String tag = "table";
    private static HashMap<String, HashMap<String, String>> validParentMap = new HashMap();
    private boolean hasHead = false;
    private boolean hasFoot = false;
    private String caption = "";
    private final ArrayList<String> widthList = new ArrayList();

    public static String getTag() {
        return tag;
    }

    public Table() {
        this.setNodeName(tag);
        this.setFormatType(3);
    }

    @Override
    public void closed() {
        boolean hasRows = false;
        if (this.hasChildNodes() && this.getNumberOfChildNodes() > 0) {
            for (NodeImpl child : this.getTrafoChildNodes()) {
                ElementImpl elem;
                if (!(child instanceof HtmlElement) || !((elem = (ElementImpl)child) instanceof Tr) && !(elem instanceof Tbody)) continue;
                hasRows = true;
            }
        }
        if (!hasRows) {
            this.appendChild(new Tr().appendChild(new Td()));
        }
    }

    private String cmpWidth(String width1, String width2) {
        int w2;
        if (!(width1 != null && width1.length() != 0 || width2 != null && width2.length() != 0)) {
            return "";
        }
        if (width1 == null || width1.length() == 0) {
            return width2;
        }
        if (width2 == null || width2.length() == 0) {
            return width1;
        }
        if (width1.endsWith("%") && !width2.endsWith("%")) {
            return width1;
        }
        if (width2.endsWith("%") && !width1.endsWith("%")) {
            return width2;
        }
        int w1 = this.widthToNumber(width1);
        if (w1 > (w2 = this.widthToNumber(width2))) {
            return width1;
        }
        return width2;
    }

    public String getCaption() {
        return this.caption;
    }

    public ArrayList<String> getColWidths() {
        this.getNumOfCols();
        return this.widthList;
    }

    public int getNumOfCols() {
        int cols = 0;
        this.widthList.clear();
        for (NodeImpl child : this.getTrafoChildNodes()) {
            int n;
            if (child instanceof Caption) {
                this.caption = child.getTextContent();
            }
            if (child instanceof Thead) {
                this.hasHead = true;
                for (NodeImpl row : child.getTrafoChildNodes()) {
                    if (!(row instanceof Tr) || (n = this.getNumOfColsInRow((Tr)row)) <= cols) continue;
                    cols = n;
                }
            }
            if (child instanceof Tfoot) {
                this.hasFoot = true;
                for (NodeImpl row : child.getTrafoChildNodes()) {
                    if (!(row instanceof Tr) || (n = this.getNumOfColsInRow((Tr)row)) <= cols) continue;
                    cols = n;
                }
            }
            if (child instanceof Tbody) {
                for (NodeImpl row : child.getTrafoChildNodes()) {
                    if (!(row instanceof Tr) || (n = this.getNumOfColsInRow((Tr)row)) <= cols) continue;
                    cols = n;
                }
            }
            if (!(child instanceof Tr) || (n = this.getNumOfColsInRow((Tr)child)) <= cols) continue;
            cols = n;
        }
        if (cols < 0) {
            return 0;
        }
        return cols;
    }

    private int getNumOfColsInRow(Tr row) {
        int index = 0;
        int colspans = 0;
        NodeListImpl cols = row.getTrafoChildNodes();
        this.widthList.ensureCapacity(cols.size());
        for (NodeImpl node : cols) {
            if (!(node instanceof TableColumnElement)) continue;
            TableColumnElement col = (TableColumnElement)node;
            String width = col.getWidth();
            String val = this.widthList.size() >= index + 1 ? this.widthList.get(index) : "";
            if (this.widthList.size() <= index) {
                this.widthList.add(index, this.cmpWidth(val, width));
            } else {
                this.widthList.set(index, this.cmpWidth(val, width));
            }
            col.setIndex(++index + colspans);
            if (col.getColspan() <= 1) continue;
            colspans += col.getColspan() - 1;
        }
        return index;
    }

    public boolean hasBorder() {
        String attr = this.getAttribute("border");
        return attr != null && attr.length() != 0 && !attr.equals("0");
    }

    public boolean hasFoot() {
        return this.hasFoot;
    }

    public boolean hasHead() {
        return this.hasHead;
    }

    private int widthToNumber(String width) {
        int w;
        char c;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < width.length() && Character.isDigit(c = width.charAt(i)); ++i) {
            buffer.append(c);
        }
        try {
            w = Integer.parseInt(buffer.toString());
        }
        catch (NumberFormatException oops) {
            w = 1;
        }
        return w;
    }

    static {
        validParentMap.put(Applet.getTag(), Applet.getAttributeMap());
        validParentMap.put(Blockquote.getTag(), HtmlElement.getAttributeMap());
        validParentMap.put(Body.getTag(), HtmlElement.getAttributeMap());
        validParentMap.put(Button.getTag(), Button.getAttributeMap());
        validParentMap.put(Center.getTag(), HtmlElement.getAttributeMap());
        validParentMap.put(Dd.getTag(), HtmlElement.getAttributeMap());
        validParentMap.put(Del.getTag(), Del.getAttributeMap());
        validParentMap.put(Div.getTag(), HtmlElement.getAttributeMap());
        validParentMap.put(Fieldset.getTag(), Fieldset.getAttributeMap());
        validParentMap.put(Form.getTag(), Form.getAttributeMap());
        validParentMap.put(Iframe.getTag(), Iframe.getAttributeMap());
        validParentMap.put(Ins.getTag(), Ins.getAttributeMap());
        validParentMap.put(Li.getTag(), HtmlElement.getAttributeMap());
        validParentMap.put(Map.getTag(), Map.getAttributeMap());
        validParentMap.put(Noframes.getTag(), HtmlElement.getAttributeMap());
        validParentMap.put(Noscript.getTag(), HtmlElement.getAttributeMap());
        validParentMap.put(HtmlObject.getTag(), HtmlObject.getAttributeMap());
        validParentMap.put(Td.getTag(), HtmlElement.getAttributeMap());
        validParentMap.put(Th.getTag(), HtmlElement.getAttributeMap());
    }
}

