/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.tag.docbook;

import org.dbdoclet.service.StringServices;
import org.dbdoclet.tag.docbook.DocBookElement;

public class Imagedata
extends DocBookElement {
    Imagedata() {
        super("imagedata");
        this.isEmpty(true);
        this.setFormatType(3);
    }

    public DocBookElement setAlign(String align) {
        if (align == null) {
            throw new IllegalArgumentException("Parameter align is null!");
        }
        this.setAttribute("align", align);
        return this;
    }

    public DocBookElement setContentDepth(String depth) {
        if (depth == null || depth.trim().length() == 0) {
            this.removeAttribute("contentdepth");
        }
        this.setAttribute("contentdepth", depth);
        return this;
    }

    public DocBookElement setContentWidth(String width) {
        if (width == null || width.trim().length() == 0) {
            this.removeAttribute("contentwidth");
        }
        this.setAttribute("contentwidth", width);
        return this;
    }

    public DocBookElement setDepth(String depth) {
        if (depth == null || depth.trim().length() == 0) {
            this.removeAttribute("depth");
        }
        this.setAttribute("depth", depth);
        return this;
    }

    public DocBookElement setFileRef(String fileref) {
        if (fileref == null) {
            throw new IllegalArgumentException("Parameter fileref is null!");
        }
        fileref = StringServices.replace(fileref, "\\", "/");
        this.setAttribute("fileref", fileref);
        return this;
    }

    public DocBookElement setFormat(String format) {
        if (format == null) {
            throw new IllegalArgumentException("Parameter format is null!");
        }
        this.setAttribute("format", format.toUpperCase());
        return this;
    }

    public DocBookElement setScale(int scale) {
        this.setAttribute("scale", String.valueOf(scale));
        return this;
    }

    public DocBookElement setScaleFit(boolean scalefit) {
        if (scalefit) {
            this.setAttribute("scalefit", "1");
        } else {
            this.setAttribute("scalefit", "0");
        }
        return this;
    }

    public DocBookElement setWidth(String width) {
        if (width == null) {
            throw new IllegalArgumentException("Parameter width is null!");
        }
        this.setAttribute("width", width);
        return this;
    }
}

