/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.tag.docbook;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.tag.docbook.AttributeAlign;
import org.dbdoclet.tag.docbook.BaseTagFactory;
import org.dbdoclet.tag.docbook.Chapter;
import org.dbdoclet.tag.docbook.Classname;
import org.dbdoclet.tag.docbook.Classsynopsisinfo;
import org.dbdoclet.tag.docbook.Colspec;
import org.dbdoclet.tag.docbook.Computeroutput;
import org.dbdoclet.tag.docbook.Date;
import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.DocBookTagFactoryException;
import org.dbdoclet.tag.docbook.DocBookVersion;
import org.dbdoclet.tag.docbook.Email;
import org.dbdoclet.tag.docbook.Emphasis;
import org.dbdoclet.tag.docbook.Entry;
import org.dbdoclet.tag.docbook.Example;
import org.dbdoclet.tag.docbook.Exceptionname;
import org.dbdoclet.tag.docbook.Figure;
import org.dbdoclet.tag.docbook.Firstname;
import org.dbdoclet.tag.docbook.Formalpara;
import org.dbdoclet.tag.docbook.Function;
import org.dbdoclet.tag.docbook.Holder;
import org.dbdoclet.tag.docbook.Imagedata;
import org.dbdoclet.tag.docbook.Imageobject;
import org.dbdoclet.tag.docbook.Info;
import org.dbdoclet.tag.docbook.Initializer;
import org.dbdoclet.tag.docbook.Interfacename;
import org.dbdoclet.tag.docbook.Link;
import org.dbdoclet.tag.docbook.Literal;
import org.dbdoclet.tag.docbook.Manvolnum;
import org.dbdoclet.tag.docbook.Mediaobject;
import org.dbdoclet.tag.docbook.Methodname;
import org.dbdoclet.tag.docbook.Modifier;
import org.dbdoclet.tag.docbook.Olink;
import org.dbdoclet.tag.docbook.Parameter;
import org.dbdoclet.tag.docbook.Primary;
import org.dbdoclet.tag.docbook.Programlisting;
import org.dbdoclet.tag.docbook.Refmiscinfo;
import org.dbdoclet.tag.docbook.Refname;
import org.dbdoclet.tag.docbook.Refsect1;
import org.dbdoclet.tag.docbook.Refsect2;
import org.dbdoclet.tag.docbook.Refsection;
import org.dbdoclet.tag.docbook.Releaseinfo;
import org.dbdoclet.tag.docbook.Secondary;
import org.dbdoclet.tag.docbook.Sect1;
import org.dbdoclet.tag.docbook.Sect2;
import org.dbdoclet.tag.docbook.Sect3;
import org.dbdoclet.tag.docbook.Section;
import org.dbdoclet.tag.docbook.Simpara;
import org.dbdoclet.tag.docbook.Simplelist;
import org.dbdoclet.tag.docbook.Surname;
import org.dbdoclet.tag.docbook.Tgroup;
import org.dbdoclet.tag.docbook.Title;
import org.dbdoclet.tag.docbook.Varname;
import org.dbdoclet.tag.docbook.Warning;
import org.dbdoclet.tag.docbook.Xref;
import org.dbdoclet.tag.docbook.Year;
import org.dbdoclet.tag.html.Img;
import org.dbdoclet.xiphias.ImageServices;
import org.dbdoclet.xiphias.NodeSerializer;
import org.dbdoclet.xiphias.dom.ElementImpl;

public class DocBookTagFactory
extends BaseTagFactory {
    protected DocBookVersion docBookVersion = DocBookVersion.V5_0;

    public DocBookTagFactory() {
        this(DocBookVersion.V5_0);
    }

    public DocBookTagFactory(DocBookVersion docBookVersion) {
        this.docBookVersion = docBookVersion;
    }

    public Chapter createChapter(String titleText) {
        Chapter chapter = new Chapter();
        this.initialize(chapter);
        Info info = this.createInfo();
        chapter.appendChild(info);
        Title title = this.createTitle(titleText);
        info.appendChild(title);
        return chapter;
    }

    public Classname createClassName(String name) {
        Classname className = new Classname(name);
        this.initialize(className);
        return className;
    }

    public Classsynopsisinfo createClasssynopsisinfo(String text) {
        Classsynopsisinfo classSynopsisInfo = new Classsynopsisinfo(text);
        this.initialize(classSynopsisInfo);
        return classSynopsisInfo;
    }

    public Colspec createColspec(String string, String width) {
        Colspec colspec = new Colspec(string, width);
        this.initialize(colspec);
        return colspec;
    }

    public Computeroutput createComputeroutput(String text) {
        Computeroutput computeroutput = new Computeroutput(text);
        this.initialize(computeroutput);
        return computeroutput;
    }

    public Date createDate(String text) {
        Date date = new Date(text);
        this.initialize(date);
        return date;
    }

    public DocBookElement createElementByName(String tagName) {
        String pkg = "org.dbdoclet.tag.docbook.";
        String lowerCase = tagName.toLowerCase();
        DocBookElement elem = null;
        Class<?> clazz = null;
        for (int i = 0; i < lowerCase.length(); ++i) {
            String name = this.upcase(lowerCase, 0, i);
            try {
                clazz = Class.forName(pkg + name);
                if (clazz == null || (elem = (DocBookElement)clazz.newInstance()) == null) continue;
                break;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return elem;
    }

    public Email createEmail(String address) {
        Email email = this.createEmail();
        email.appendChild(address);
        return email;
    }

    public Emphasis createEmphasis(String str) {
        Emphasis emphasis = new Emphasis(str);
        this.initialize(emphasis);
        return emphasis;
    }

    public Emphasis createEmphasis(String str, String role) {
        Emphasis emphasis = this.createEmphasis(str);
        emphasis.setRole(role);
        return emphasis;
    }

    public Entry createEntry(String text) {
        Entry entry = new Entry(text);
        this.initialize(entry);
        return entry;
    }

    public Example createExample(String title) {
        Example example = new Example();
        this.initialize(example);
        example.appendChild(this.createTitle(title));
        return example;
    }

    public Exceptionname createExceptionname(String text) {
        Exceptionname exceptionName = new Exceptionname(text);
        this.initialize(exceptionName);
        return exceptionName;
    }

    public Figure createFigure(String title) {
        Figure figure = new Figure();
        this.initialize(figure);
        figure.appendChild(this.createTitle(title));
        return figure;
    }

    public Firstname createFirstname(String name) {
        Firstname firstName = this.createFirstname();
        firstName.appendChild(name);
        return firstName;
    }

    public void createFoImageData(DocBookElement parent, BaseTagFactory dbfactory, Img img, File file, List<String> additionalFormats) throws IOException {
        String fileRef = FileServices.normalizePath(file.getPath());
        String imgFormat = this.getImagedataFormat(fileRef);
        if (FileServices.isAbsolutePath(fileRef = FileServices.getFileBase(fileRef))) {
            fileRef = (fileRef = FileServices.normalizePath(fileRef)).startsWith("/") ? "file://" + fileRef : "file:///" + fileRef;
        }
        HashSet<String> formatList = new HashSet<String>();
        formatList.add(imgFormat);
        if (additionalFormats != null) {
            additionalFormats.forEach(f -> formatList.add(f.toUpperCase()));
        }
        for (String format : formatList) {
            Imageobject image = dbfactory.createImageobject();
            if (format.equals(imgFormat)) {
                image.setRole("fo");
            } else {
                image.setRole("fo-" + format.toLowerCase());
            }
            String align = img.getAlign();
            Imagedata data = dbfactory.createImagedata();
            data.setScaleFit(true);
            data.setWidth("100%");
            data.setContentDepth("100%");
            data.setFormat(format);
            if (align != null && align.length() > 0) {
                data.setAlign(this.validateAlign(align));
            }
            data.setFileRef(fileRef + "." + format.toLowerCase());
            image.appendChild(data);
            parent.appendChild(image);
        }
    }

    public DocBookElement createFormalpara(String text) {
        Formalpara formalPara = this.createFormalpara();
        formalPara.appendChild(text);
        return formalPara;
    }

    public Function createFunction(String func) {
        Function function = new Function();
        function.appendChild(func);
        this.initialize(function);
        return function;
    }

    public Holder createHolder(String text) {
        Holder holder = new Holder();
        holder.appendChild(text);
        this.initialize(holder);
        return holder;
    }

    public void createHtmlImageData(DocBookElement parent, BaseTagFactory dbfactory, Img img, File file, List<String> additionalFormats) throws IOException {
        String fileRef = FileServices.normalizePath(file.getPath());
        if (FileServices.isAbsolutePath(fileRef)) {
            fileRef = (fileRef = FileServices.normalizePath(fileRef)).startsWith("/") ? "file://" + fileRef : "file:///" + fileRef;
        }
        String imgFormat = this.getImagedataFormat(fileRef);
        fileRef = FileServices.getFileBase(fileRef);
        if (imgFormat == null) {
            return;
        }
        String width = img.getWidth();
        String height = img.getHeight();
        String align = img.getAlign();
        HashSet<String> formatList = new HashSet<String>();
        formatList.add(imgFormat);
        if (additionalFormats != null) {
            additionalFormats.forEach(f -> formatList.add(f.toUpperCase()));
        }
        for (String format : formatList) {
            Imageobject image = dbfactory.createImageobject();
            if (format.equals(imgFormat)) {
                image.setRole("html");
            } else {
                image.setRole("html-" + format.toLowerCase());
            }
            Imagedata data = dbfactory.createImagedata();
            data.setScaleFit(true);
            if (width != null && width.length() > 0) {
                data.setContentWidth(width);
            }
            if (height != null && height.length() > 0) {
                data.setContentDepth(height);
            }
            if (file.exists() && format.equalsIgnoreCase("BASE64")) {
                String fileName = FileServices.getFileBase(file) + ".base64";
                FileServices.writeFromString(new File(fileName), ImageServices.toXml(file));
            }
            data.setFormat(format);
            if (align != null && align.length() > 0) {
                data.setAlign(this.validateAlign(align));
            }
            String attr = fileRef + "." + format.toLowerCase();
            data.setFileRef(attr);
            image.appendChild(data);
            parent.appendChild(image);
        }
    }

    public Mediaobject createImage(String image) {
        return this.createImage(image, null, null);
    }

    public Mediaobject createImage(String image, String width, String height) {
        Mediaobject mediaObject = this.createMediaobject();
        Imageobject imageObject = this.createImageobject();
        mediaObject.appendChild(imageObject);
        Imagedata imageData = this.createImagedata();
        imageObject.appendChild(imageData);
        imageData.setFileRef(image);
        if (width != null && width.trim().length() > 0) {
            imageData.setWidth(String.valueOf(width));
        }
        if (height != null && height.trim().length() > 0) {
            imageData.setDepth(String.valueOf(height));
        }
        return mediaObject;
    }

    public Initializer createInitializer(String text) {
        Initializer initializer = new Initializer(text);
        this.initialize(initializer);
        return initializer;
    }

    public Interfacename createInterfacename(String name) {
        Interfacename interfaceName = new Interfacename(name);
        this.initialize(interfaceName);
        return interfaceName;
    }

    public Link createLink(Literal literal, String ref) {
        Link link = new Link(literal, ref);
        this.initialize(link);
        return link;
    }

    public Link createLink(String linkend) {
        Link link = new Link(linkend);
        this.initialize(link);
        return link;
    }

    public Link createLink(String label, String ref) {
        Link link = new Link(label, ref);
        this.initialize(link);
        return link;
    }

    public Link createLink(Varname varName, String ref) {
        Link link = new Link(varName, ref);
        this.initialize(link);
        return link;
    }

    public String createLinkAsString(String label, String ref) throws IOException {
        Link link = new Link(label, ref);
        this.initialize(link);
        return new NodeSerializer().toXML(link);
    }

    public Literal createLiteral(String text) {
        Literal literal = new Literal(text);
        this.initialize(literal);
        return literal;
    }

    public Manvolnum createManvolnum(String num) {
        Manvolnum manVolNum = new Manvolnum();
        this.initialize(manVolNum);
        manVolNum.appendChild(num);
        return manVolNum;
    }

    public Methodname createMethodname(String name) {
        Methodname methodName = this.createMethodname();
        methodName.appendChild(name);
        return methodName;
    }

    public Modifier createModifier(String text) {
        Modifier modifier = new Modifier();
        modifier.appendChild(text);
        this.initialize(modifier);
        return modifier;
    }

    public Olink createOlink(String label, String targetdoc, String targetptr) {
        Olink olink = new Olink(label, targetdoc, targetptr);
        this.initialize(olink);
        return olink;
    }

    public Parameter createParameter(String name) {
        Parameter parameter = new Parameter();
        this.initialize(parameter);
        parameter.appendChild(name);
        return parameter;
    }

    public Primary createPrimary(String key) {
        Primary primary = new Primary();
        this.initialize(primary);
        primary.appendChild(key);
        return primary;
    }

    public Programlisting createProgramlisting(String str) {
        Programlisting programListing = new Programlisting(str);
        this.initialize(programListing);
        return programListing;
    }

    public Refmiscinfo createRefmiscinfo(String clazz, String info) {
        Refmiscinfo refMiscInfo = new Refmiscinfo();
        this.initialize(refMiscInfo);
        refMiscInfo.setAttribute("class", clazz);
        refMiscInfo.appendChild(refMiscInfo);
        return refMiscInfo;
    }

    public Refname createRefname(String name) {
        Refname refname = this.createRefname();
        refname.appendChild(name);
        return refname;
    }

    public Refsect1 createRefsect1(String title) {
        Refsect1 refSect1 = this.createRefsect1();
        refSect1.appendChild(this.createTitle(title));
        return refSect1;
    }

    public Refsect2 createRefsect2(String title) {
        Refsect2 refSect2 = this.createRefsect2();
        refSect2.appendChild(this.createTitle(title));
        this.initialize(refSect2);
        return refSect2;
    }

    public Refsection createRefsection(String title) {
        Refsection refSection = this.createRefsection();
        refSection.appendChild(this.createTitle(title));
        return refSection;
    }

    public Releaseinfo createReleaseinfo(String text) {
        Releaseinfo releaseInfo = new Releaseinfo();
        releaseInfo.appendChild(text);
        this.initialize(releaseInfo);
        return releaseInfo;
    }

    public Secondary createSecondary(String key) {
        Secondary secondary = new Secondary();
        this.initialize(secondary);
        secondary.appendChild(key);
        return secondary;
    }

    public Sect1 createSect1(String title) {
        Sect1 sect1 = this.createSect1();
        sect1.appendChild(this.createTitle(title));
        return sect1;
    }

    public Sect2 createSect2(String str) {
        Sect2 sect2 = this.createSect2();
        sect2.appendChild(this.createTitle(str));
        return sect2;
    }

    public Sect3 createSect3(String str) {
        Sect3 sect3 = this.createSect3();
        sect3.appendChild(this.createTitle(str));
        return sect3;
    }

    public Section createSection(String title) {
        Section section = this.createSection();
        section.appendChild(this.createTitle(title));
        return section;
    }

    public Simpara createSimpara(String text) {
        Simpara simPara = new Simpara();
        this.initialize(simPara);
        simPara.appendChild(text);
        return simPara;
    }

    public Simplelist createSimplelist(int type) {
        Simplelist simpleList = this.createSimplelist();
        simpleList.setType(type);
        return simpleList;
    }

    public Surname createSurname(String name) {
        Surname surname = new Surname();
        surname.appendChild(name);
        this.initialize(surname);
        return surname;
    }

    public DocBookElement createTag(String name) throws DocBookTagFactoryException {
        DocBookElement docBookElement = new DocBookElement(name);
        this.initialize(docBookElement);
        return docBookElement;
    }

    public Tgroup createTgroup(int cols) {
        Tgroup tgroup = new Tgroup();
        this.initialize(tgroup);
        tgroup.setCols(2);
        tgroup.appendChild(this.createColspec("c1", "1*"));
        tgroup.appendChild(this.createColspec("c2", "1*"));
        return tgroup;
    }

    public Title createTitle(String str) {
        Title title = new Title(str);
        this.initialize(title);
        return title;
    }

    public Varname createVarname(String text) {
        Varname varName = new Varname(text);
        this.initialize(varName);
        return varName;
    }

    public Warning createWarning(String text) {
        Warning warning = new Warning(text);
        this.initialize(warning);
        return warning;
    }

    public Xref createXref(String linkend) {
        Xref xref = new Xref();
        this.initialize(xref);
        xref.setAttribute("linkend", ElementImpl.hardenId(linkend));
        xref.isEmpty(true);
        xref.needsPadding(false);
        return xref;
    }

    public Year createYear(String text) {
        Year year = new Year();
        year.appendChild(text);
        this.initialize(year);
        return year;
    }

    public DocBookVersion getDocBookVersion() {
        return this.docBookVersion;
    }

    public String getImagedataFormat(String src) {
        String value;
        if (src != null && (value = FileServices.getExtension(src)) != null && value.trim().length() > 0) {
            return value.toUpperCase();
        }
        return null;
    }

    public boolean isDocBook5() {
        return this.docBookVersion != null && this.docBookVersion == DocBookVersion.V5_0;
    }

    public String validateAlign(String align) {
        if (align == null) {
            return align;
        }
        align = align.toLowerCase();
        try {
            AttributeAlign.valueOf(align.toUpperCase());
        }
        catch (IllegalArgumentException oops) {
            return AttributeAlign.CENTER.toString().toLowerCase();
        }
        return align;
    }

    private String upcase(String lowerCase, int ... indices) {
        char[] chars = lowerCase.toCharArray();
        for (int index : indices) {
            chars[index] = Character.toUpperCase(chars[index]);
        }
        return new String(chars);
    }

    @Override
    protected void initialize(DocBookElement elem) {
        elem.setDocBookVersion(this.docBookVersion);
        elem.setNamespaceURI("http://docbook.org/ns/docbook");
    }
}

