/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.tag.docbook;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.dbdoclet.ValidationResult;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.tag.ITransformPosition;
import org.dbdoclet.tag.docbook.DocBookSchemaValidatorErrorHandler;
import org.dbdoclet.xiphias.NodeSerializer;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DocBookSchemaValidator {
    private static DocBookSchemaValidator singleton;
    private Validator validator;

    private DocBookSchemaValidator() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaUrl = ResourceServices.getResourceAsUrl("/xsd/docbook/docbook.xsd");
        Schema schema = schemaFactory.newSchema(schemaUrl);
        this.validator = schema.newValidator();
        this.validator.setErrorHandler(new DocBookSchemaValidatorErrorHandler());
    }

    public ValidationResult validate(ITransformPosition pos, Node node) {
        ValidationResult result = new ValidationResult();
        try {
            this.validator.validate(new DOMSource(node));
            result.setValid(true);
            return result;
        }
        catch (IOException | SAXException oops) {
            String description = "";
            if (pos != null) {
                description = pos.getDescription();
            }
            result.setMessage(String.format("[%s] %s:\nXML::%s::\n%s\n", description, oops.getClass().getSimpleName(), new NodeSerializer().toXML(node), StringServices.splitAt(oops.getMessage(), " ")));
            result.setValid(false);
            return result;
        }
    }

    public static DocBookSchemaValidator getInstance() throws SAXException {
        if (singleton == null) {
            singleton = new DocBookSchemaValidator();
        }
        return singleton;
    }
}

