/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.tag.docbook;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.tag.ITransformPosition;
import org.dbdoclet.tag.docbook.DocBookSchemaValidator;
import org.dbdoclet.tag.docbook.DocBookVersion;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DocBookElement
extends ElementImpl {
    private static Log logger = LogFactory.getLog(DocBookElement.class);
    private DocBookVersion docBookVersion = DocBookVersion.V5_0;

    public static HashMap<String, Object> getAttributeMap() {
        return new HashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidParent(ITransformPosition pos, Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Variable parent is null!");
        }
        if (node instanceof DocumentFragment) {
            return true;
        }
        try {
            node.appendChild(this);
            boolean bl = DocBookSchemaValidator.getInstance().validate(pos, node).isValid();
            return bl;
        }
        catch (SAXException e) {
            logger.error((Object)"", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            node.removeChild(this);
        }
    }

    public static void setFlavour(String flavour) {
        if (flavour == null) {
            throw new IllegalArgumentException(" The argument flavour must not be null!");
        }
        if (flavour.equalsIgnoreCase("xml") || flavour.equalsIgnoreCase("sgml")) {
            flavour.toLowerCase();
        }
    }

    DocBookElement(String name) {
        super(name);
    }

    public String getCondition() {
        return this.getAttribute("condition");
    }

    public DocBookVersion getDocBookVersion() {
        return this.docBookVersion;
    }

    @Override
    public String getId() {
        if (this.docBookVersion == DocBookVersion.V4_5) {
            return this.getAttribute("id");
        }
        return this.getAttribute("xml:id");
    }

    public String getRemap() {
        return this.getAttribute("remap");
    }

    protected boolean isDocBook5() {
        return this.docBookVersion == DocBookVersion.V5_0;
    }

    public boolean isList() {
        String name = this.getNodeName();
        if (name == null) {
            return false;
        }
        if (name.equalsIgnoreCase("orderedlist")) {
            return true;
        }
        if (name.equalsIgnoreCase("itemizedlist")) {
            return true;
        }
        return name.equalsIgnoreCase("variablelist");
    }

    public boolean isSection() {
        String name = this.getNodeName();
        if (name.equalsIgnoreCase("book") || name.equalsIgnoreCase("article") || name.equalsIgnoreCase("chapter") || name.equalsIgnoreCase("sect1") || name.equalsIgnoreCase("sect2") || name.equalsIgnoreCase("sect3") || name.equalsIgnoreCase("sect4") || name.equalsIgnoreCase("sect5") || name.equalsIgnoreCase("section") || name.equalsIgnoreCase("refsect1") || name.equalsIgnoreCase("refsect2") || name.equalsIgnoreCase("refsect3") || name.equalsIgnoreCase("refsect4") || name.equalsIgnoreCase("refsect5") || name.equalsIgnoreCase("refsection")) {
            return true;
        }
        if (name.equalsIgnoreCase("sect3")) {
            return true;
        }
        if (name.equalsIgnoreCase("sect4")) {
            return true;
        }
        if (name.equalsIgnoreCase("sect5")) {
            return true;
        }
        if (name.equalsIgnoreCase("section")) {
            return true;
        }
        return name.equalsIgnoreCase("simplesect");
    }

    public DocBookElement setCondition(String condition) {
        if (condition == null) {
            return this;
        }
        this.setAttribute("condition", condition);
        return this;
    }

    public void setDocBookVersion(DocBookVersion docBookVersion) {
        this.docBookVersion = docBookVersion;
    }

    @Override
    public void setId(int number) {
        if (this.docBookVersion == DocBookVersion.V4_5) {
            this.setAttribute("id", String.valueOf(number));
        } else {
            this.setAttribute("xml:id", String.valueOf(number));
        }
    }

    @Override
    public void setId(String id) {
        if (id == null || id.length() == 0) {
            return;
        }
        if (this.docBookVersion == DocBookVersion.V5_0) {
            this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:id", DocBookElement.hardenId(id));
        } else {
            this.setAttribute("id", DocBookElement.hardenId(id));
        }
    }

    public void setLang(String lang) {
        if (lang == null || lang.length() == 0) {
            return;
        }
        if (this.docBookVersion == DocBookVersion.V5_0) {
            this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", lang);
        } else {
            this.setAttribute("lang", lang);
        }
    }

    public DocBookElement setRemap(String remap) {
        if (remap == null) {
            return this;
        }
        this.setAttribute("remap", remap);
        return this;
    }

    public DocBookElement setRole(String role) {
        if (role == null) {
            return this;
        }
        this.setAttribute("role", role);
        return this;
    }

    public DocBookElement setXrefLabel(String label) {
        if (label == null) {
            return this;
        }
        this.setAttribute("xreflabel", label);
        return this;
    }

    public boolean isInline() {
        return this.getFormatType() == 1;
    }
}

