/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service.file;

import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.service.FileVisitor;

public class NumberVisitor
implements FileVisitor {
    private int number = 0;
    private final ProgressListener listener;
    private final String msg;
    private final FilenameFilter filter;

    public NumberVisitor(FilenameFilter filter, String msg, ProgressListener listener) {
        this.filter = filter;
        this.msg = msg;
        this.listener = listener;
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public void visit(File file) {
        if (this.filter != null && !this.filter.accept(file, file.getName())) {
            return;
        }
        ++this.number;
        if (this.listener != null) {
            this.listener.progress(new ProgressEvent(MessageFormat.format(this.msg, String.valueOf(this.number))));
        }
    }
}

