/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.FindServices;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.service.StringServices;

public class ZipServices {
    private static Log logger = LogFactory.getLog(ZipServices.class);
    private static final int BUFFER = 2048;

    public static void zip(File archiveFile, File srcDir) throws IOException {
        ZipServices.zip(archiveFile, srcDir, "");
    }

    public static void zip(File archiveFile, File srcDir, String prefix) throws IOException {
        ZipServices.zip(archiveFile, srcDir, srcDir, prefix);
    }

    public static void zip(File archiveFile, File srcDir, File baseDir) throws IOException {
        ZipServices.zip(archiveFile, srcDir, baseDir, "");
    }

    public static void zip(File archiveFile, File srcDir, File baseDir, String prefix) throws IOException {
        FileOutputStream fos = new FileOutputStream(archiveFile);
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));
        ArrayList<File> fileList = new ArrayList<File>();
        FindServices.findFile(srcDir, "^.*$", fileList);
        byte[] data = new byte[2048];
        for (File file : fileList) {
            int count;
            String path = file.getCanonicalPath();
            path = StringServices.cutPrefix(path, baseDir.getCanonicalPath());
            path = StringServices.cutPrefix(path, File.separator);
            if (prefix != null && prefix.trim().length() > 0) {
                path = FileServices.appendFileName(prefix, path);
            }
            path = FileServices.normalizePath(path);
            ZipEntry entry = new ZipEntry(path);
            zos.putNextEntry(entry);
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis, 2048);
            while ((count = bis.read(data, 0, 2048)) != -1) {
                zos.write(data, 0, count);
            }
            bis.close();
            fis.close();
        }
        zos.close();
    }

    public static void unzip(File archiveFile, File destDir) throws IOException {
        if (archiveFile == null) {
            throw new IllegalArgumentException("The argument archiveFile must not be null!");
        }
        ZipServices.unzip(new FileInputStream(archiveFile), destDir);
    }

    public static void unzip(URL url, File destDir) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("The argument url must not be null!");
        }
        logger.debug((Object)("url = " + url));
        logger.debug((Object)("destDir = " + destDir));
        InputStream instr = null;
        try {
            instr = url.openStream();
            ZipServices.unzip(instr, destDir);
            instr.close();
        }
        catch (IOException oops) {
            logger.error((Object)("Can't unzip URL " + url.toString()), (Throwable)oops);
            throw oops;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream instr, File destDir) throws IOException {
        if (instr == null) {
            throw new IllegalArgumentException("The argument instr must not be null!");
        }
        if (destDir == null) {
            throw new IllegalArgumentException("The argument destDir may not be null!");
        }
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            FileServices.createPath(destDir);
            zis = new ZipInputStream(instr);
            while ((entry = zis.getNextEntry()) != null) {
                int nread;
                String destName;
                logger.debug((Object)("entry = " + entry));
                String fileName = FileServices.normalizePath(entry.getName());
                if (entry.isDirectory()) {
                    destName = FileServices.appendPath(destDir, fileName);
                    FileServices.createPath(destName);
                    continue;
                }
                destName = FileServices.appendFileName(destDir, fileName);
                File file = new File(destName);
                File parent = file.getParentFile();
                if (parent != null) {
                    FileServices.createPath(parent.getAbsolutePath());
                }
                FileOutputStream outstr = new FileOutputStream(destName);
                byte[] buffer = new byte[4092];
                while ((nread = zis.read(buffer)) != -1) {
                    outstr.write(buffer, 0, nread);
                }
                outstr.flush();
                outstr.close();
            }
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception oops) {
                    oops.printStackTrace();
                }
            }
        }
    }

    public static void unpackJar(String resource, String destPath) throws IOException {
        ZipServices.unpackJar(resource, new File(destPath), false);
    }

    public static void unpackJar(String resource, String destPath, boolean ifNewer) throws IOException {
        ZipServices.unpackJar(resource, new File(destPath), ifNewer);
    }

    public static void unpackJar(String resource, File dir) throws IOException {
        ZipServices.unpackJar(resource, dir, false);
    }

    public static void unpackJar(String resource, File dir, boolean ifNewer) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("The argument resource must not be null!");
        }
        if (dir == null) {
            throw new IllegalArgumentException("The argument dir must not be null!");
        }
        String tsFileName = FileServices.appendFileName(dir, "unpackJar.ts");
        File tsFile = new File(tsFileName);
        URL url = ResourceServices.getResourceAsUrl(resource);
        if (url == null) {
            throw new IOException("Cant find resource " + resource + ".");
        }
        String protocol = url.getProtocol();
        logger.debug((Object)("protocol = " + protocol));
        if (protocol.equals("jar")) {
            File jarFile;
            boolean unpack = true;
            String path = url.getFile();
            int index = path.indexOf(".jar!");
            if (index != -1) {
                path = path.substring(0, index + 4);
            }
            if ((protocol = (url = new URL(path)).getProtocol()).equals("file") && ifNewer && (jarFile = new File(url.getFile())).exists() && !FileServices.newer(jarFile, tsFile) && ifNewer) {
                unpack = false;
            }
            if (unpack) {
                ZipServices.unzip(url, dir);
                FileServices.touch(tsFileName);
            }
        }
    }
}

