/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnicodeServices {
    private static Pattern pattern = Pattern.compile("\\\\u[0-9a-fA-F]{4}");

    public static String escape(char c) {
        char[] v = new char[]{c};
        return UnicodeServices.escape(new String(v));
    }

    public static String escape(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c;
            char n = c = str.charAt(i);
            if (c == '\r') continue;
            if (n >= '\u0000' && n < '\u0080' && c != '\n' && c != '\\') {
                buffer.append(c);
                continue;
            }
            buffer.append("\\u");
            String hex = Integer.toHexString(n);
            for (int j = 0; j < 4 - hex.length(); ++j) {
                buffer.append("0");
            }
            buffer.append(hex);
        }
        return buffer.toString();
    }

    public static String unescape(String str) {
        Matcher matcher = pattern.matcher(str);
        char[] c = new char[1];
        while (matcher.find()) {
            String escape = matcher.group();
            c[0] = (char)Integer.parseInt(escape.substring(2), 16);
            String buffer = new String(c);
            String part1 = str.substring(0, matcher.start());
            String part2 = str.substring(matcher.end());
            str = part1 + buffer + part2;
            matcher.reset(str);
        }
        return str;
    }

    public static String removeUndefinedCharacters(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        StringBuffer textBuffer = new StringBuffer(text);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < textBuffer.length(); ++i) {
            char c = textBuffer.charAt(i);
            if (c == '\n' || c == '\t') {
                buffer.append(c);
                continue;
            }
            if (Character.isISOControl(c) || !Character.isDefined(c)) continue;
            buffer.append(c);
        }
        return buffer.toString();
    }
}

