/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service;

import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.Sfv;

public class StringServices {
    public static final Log logger = LogFactory.getLog(StringServices.class);
    public static final String ZERO_WIDTH_SPACE = "\u200b";
    public static final String SIX_PER_EM_SPACE = "\u2006";
    public static final String SOFT_HYPHEN = "\u00ad";

    public static String replace(String str, String pattern, String subst) {
        if (str == null) {
            return null;
        }
        if (pattern == null) {
            return str;
        }
        if (subst == null) {
            subst = "";
        }
        if (pattern.equals(subst)) {
            return str;
        }
        int fromIndex = 0;
        int toIndex = 0;
        String pattern2 = "{" + pattern + "}";
        if (str.indexOf(pattern) == -1 && str.indexOf(pattern2) == -1) {
            return str;
        }
        StringBuffer buffer = new StringBuffer();
        while ((toIndex = str.indexOf(pattern2, toIndex)) != -1) {
            buffer.append(str.substring(fromIndex, toIndex));
            buffer.append(subst);
            toIndex = fromIndex = toIndex + pattern2.length();
        }
        buffer.append(str.substring(fromIndex));
        fromIndex = 0;
        toIndex = 0;
        str = buffer.toString();
        buffer = new StringBuffer();
        while ((toIndex = str.indexOf(pattern, toIndex)) != -1) {
            buffer.append(str.substring(fromIndex, toIndex));
            buffer.append(subst);
            toIndex = fromIndex = toIndex + pattern.length();
        }
        buffer.append(str.substring(fromIndex));
        return buffer.toString();
    }

    public static String replaceIgnoreCase(String str, String pattern, String subst) {
        if (str == null) {
            return null;
        }
        if (pattern == null) {
            return str;
        }
        if (subst == null) {
            subst = "";
        }
        int fromIndex = 0;
        int toIndex = 0;
        String buffer = "";
        String lowerStr = str.toLowerCase();
        String lowerPattern = pattern.toLowerCase();
        String pattern2 = "{" + lowerPattern + "}";
        while ((toIndex = lowerStr.indexOf(pattern2, toIndex)) != -1) {
            buffer = buffer + str.substring(fromIndex, toIndex);
            buffer = buffer + subst;
            toIndex = fromIndex = toIndex + pattern2.length();
        }
        buffer = buffer + str.substring(fromIndex);
        fromIndex = 0;
        toIndex = 0;
        str = buffer;
        buffer = "";
        while ((toIndex = lowerStr.indexOf(lowerPattern, toIndex)) != -1) {
            buffer = buffer + str.substring(fromIndex, toIndex);
            buffer = buffer + subst;
            toIndex = fromIndex = toIndex + lowerPattern.length();
        }
        buffer = buffer + str.substring(fromIndex);
        return buffer;
    }

    public static String createIndent(int len) {
        StringBuffer indent = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            indent.append(' ');
        }
        return indent.toString();
    }

    public static String capFirstLetter(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String getFirstLetter(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char fc = str.toCharArray()[0];
        char[] chars = new char[]{fc};
        return new String(chars);
    }

    public static String lowerFirstLetter(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String createJavaIdentifier(String str, boolean mangleUnderscores) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuffer identifier = new StringBuffer();
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            identifier.append("i");
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isJavaIdentifierPart(str.charAt(i))) {
                if (mangleUnderscores) {
                    identifier.append(StringServices.mangleChar(str.charAt(i), "0x"));
                    continue;
                }
                identifier.append(StringServices.mangleChar(str.charAt(i), "_"));
                continue;
            }
            char c = str.charAt(i);
            if (c == '_' && mangleUnderscores) {
                identifier.append(StringServices.mangleChar(str.charAt(i), "0x"));
                continue;
            }
            identifier.append(str.charAt(i));
        }
        return identifier.toString();
    }

    public static String createJavaIdentifier(String str) {
        return StringServices.createJavaIdentifier(str, false);
    }

    public static String mangleChar(char c, String prefix) {
        int i;
        String s = Integer.toHexString(c);
        int nzeros = 5 - s.length();
        char[] result = new char[5];
        for (i = 0; i < nzeros; ++i) {
            result[i] = 48;
        }
        i = nzeros;
        int j = 0;
        while (i < 5) {
            result[i] = s.charAt(j);
            ++i;
            ++j;
        }
        return prefix + new String(result);
    }

    public static String createHeadline(String title) {
        if (title == null) {
            throw new IllegalArgumentException("The argument title may not be null!");
        }
        StringBuffer sep = new StringBuffer();
        for (int i = 0; i < title.length() + 4; ++i) {
            sep.append('*');
        }
        String buffer = sep + "\n" + "* " + title + " *\n" + sep + "\n\n";
        return buffer;
    }

    public static String info(String line) {
        return StringServices.align(line, 50, '.') + ": ";
    }

    public static String align(String line) {
        return StringServices.align(line, 50, '.');
    }

    public static String align(String line, int width) {
        return StringServices.align(line, width, '.');
    }

    public static String align(String line, int width, char fill) {
        if (line == null || line.length() == 0) {
            throw new IllegalArgumentException("The argument line may not be null!");
        }
        StringBuffer buffer = new StringBuffer(line);
        if (line.length() >= width) {
            buffer.append(fill);
            buffer.append(fill);
            buffer.append(fill);
            return buffer.toString();
        }
        for (int i = line.length(); i < width; ++i) {
            buffer.append(fill);
        }
        return buffer.toString();
    }

    public static String align(double d) {
        return StringServices.align((int)d);
    }

    public static String align(int i) {
        if (i >= 1000) {
            return "";
        }
        if (i >= 100) {
            return " ";
        }
        if (i >= 10) {
            return "  ";
        }
        return "   ";
    }

    public static String cutSuffix(String text, String suffix) {
        int index;
        if (suffix == null) {
            logger.warn((Object)String.format("Can't cut off a null suffix (%s)!", text));
            return text;
        }
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return text;
        }
        if (text.endsWith(suffix) && (index = text.lastIndexOf(suffix)) != -1) {
            text = text.substring(0, index);
        }
        return text;
    }

    public static String chop(String text, String suffix) {
        return StringServices.cutSuffix(text, suffix);
    }

    public static String trim(String text, char c) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(c);
        return StringServices.trim(text, buffer.toString());
    }

    public static String trim(String text, String pattern) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return text;
        }
        while (text.startsWith(pattern)) {
            text = StringServices.cutPrefix(text, pattern);
        }
        while (text.endsWith(pattern)) {
            text = StringServices.cutSuffix(text, pattern);
        }
        return text;
    }

    public static String cut(String text, String pattern) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter text is null!");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Parameter pattern is null!");
        }
        String buffer = text;
        int start = text.indexOf(pattern);
        if (start != -1) {
            buffer = text.substring(0, start);
            int end = start + pattern.length();
            if (end < text.length()) {
                buffer = buffer + text.substring(end, text.length());
            }
        }
        return buffer;
    }

    public static String cutPrefix(String text, String prefix) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter text is null!");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter prefix is null!");
        }
        if (text.length() < prefix.length()) {
            return text;
        }
        if (text.equals(prefix)) {
            return "";
        }
        String buffer = text;
        if (text.startsWith(prefix)) {
            buffer = text.length() == prefix.length() ? "" : text.substring(prefix.length());
        }
        return buffer;
    }

    public static String shorten(String text, int cols) {
        if (text == null || text.length() == 0) {
            return "";
        }
        if (cols < 5) {
            return text;
        }
        if (text.length() <= cols) {
            return text;
        }
        String msg = new String(text);
        msg = text.substring(0, cols / 2 - 3);
        msg = msg + "...";
        msg = msg + text.substring(text.length() - cols / 2);
        return msg;
    }

    public static String splitAt(String text) {
        return StringServices.splitAt(text, File.separator, 71, Sfv.LSEP);
    }

    public static String splitAt(String text, String breakable) {
        return StringServices.splitAt(text, breakable, 71, Sfv.LSEP);
    }

    public static String splitAt(String text, String breakable, int breakPos, String splitter) {
        if (text == null || text.length() == 0) {
            return "";
        }
        if (text.length() <= 3) {
            return text;
        }
        if (breakable == null || breakable.length() == 0) {
            return text;
        }
        if (breakPos <= 0 || breakPos >= text.length()) {
            return text;
        }
        if (splitter == null || splitter.length() == 0) {
            return text;
        }
        boolean doSplit = true;
        StringBuffer buffer = new StringBuffer();
        while (doSplit) {
            int greaterDistance;
            int lessDistance;
            int lessIndex = 0;
            int greaterIndex = 0;
            int index = text.indexOf(breakable);
            while (index != -1) {
                if (index <= breakPos) {
                    lessIndex = index;
                }
                if (index >= breakPos && greaterIndex == 0) {
                    greaterIndex = index;
                }
                index = text.indexOf(breakable, index + 1);
            }
            if (greaterIndex == 0) {
                greaterIndex = text.length();
            }
            if (lessIndex == 0) {
                lessIndex = breakPos;
            }
            if ((lessDistance = breakPos - lessIndex) <= (greaterDistance = greaterIndex - breakPos) || greaterIndex >= text.length()) {
                buffer.append(text.substring(0, lessIndex));
                buffer.append(splitter);
                text = text.substring(lessIndex);
            }
            if (greaterDistance < lessDistance && greaterIndex < text.length()) {
                buffer.append(text.substring(0, greaterIndex));
                buffer.append(splitter);
                text = text.substring(greaterIndex);
            }
            if (text.length() > breakPos) continue;
            buffer.append(text);
            doSplit = false;
        }
        return buffer.toString();
    }

    public static String fillInt(int num, int width) {
        if (num < 1) {
            num *= -1;
        }
        String buffer = String.valueOf(num);
        while (width > buffer.length()) {
            buffer = "0" + buffer;
        }
        return buffer;
    }

    public static String fillLeadingZero(String num, int width) {
        String buffer = String.valueOf(num);
        boolean negative = false;
        if (buffer.startsWith("-")) {
            buffer = buffer.substring(1);
            negative = true;
        }
        while (width > buffer.length()) {
            buffer = "0" + buffer;
        }
        if (negative) {
            buffer = "-" + buffer;
        }
        return buffer;
    }

    public static String makeWrapable(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        String[] tokens = new String[]{"/", "\\", "-"};
        String wrapable = new String(str);
        for (String token : tokens) {
            if (token == null || token.length() == 0) continue;
            wrapable = StringServices.replace(wrapable, token, token + ZERO_WIDTH_SPACE);
        }
        return wrapable;
    }

    public static String arrayToString(String[] array) {
        return StringServices.arrayToString(array, " ");
    }

    public static String arrayToString(String[] array, String sep) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            buffer.append(array[i]);
            buffer.append(sep);
        }
        return buffer.toString();
    }

    public static String listToString(List<? extends Object> list) {
        return StringServices.listToString(list, Sfv.LSEP);
    }

    public static String listToString(List<? extends Object> list, String sep) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            buffer.append(list.get(i));
            buffer.append(sep);
        }
        return buffer.toString();
    }

    public static String createBox(String text) {
        int i;
        StringBuilder buffer = new StringBuilder();
        buffer.append('\u2554');
        for (i = 0; i < text.length() + 2; ++i) {
            buffer.append('\u2550');
        }
        buffer.append('\u2557');
        buffer.append('\n');
        buffer.append("\u2551 ");
        buffer.append(text);
        buffer.append(" \u2551\n");
        buffer.append('\u255a');
        for (i = 0; i < text.length() + 2; ++i) {
            buffer.append('\u2550');
        }
        buffer.append('\u255d');
        buffer.append('\n');
        return buffer.toString();
    }
}

