/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.dbdoclet.Sfv;
import org.dbdoclet.progress.InfoListener;
import org.dbdoclet.service.ExecResult;

class StdInput
extends Thread {
    private BufferedReader reader;
    private InfoListener listener;
    private ExecResult result;
    private boolean doClose = false;

    public StdInput(InputStream instr, InfoListener listener, ExecResult result) {
        if (instr == null) {
            throw new IllegalArgumentException("The argument instr must not be null!");
        }
        if (result == null) {
            throw new IllegalArgumentException("The argument result may not be null!");
        }
        this.result = result;
        this.listener = listener;
        this.reader = new BufferedReader(new InputStreamReader(instr));
    }

    public void close() {
        this.doClose = true;
        try {
            this.reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            String line = this.reader.readLine();
            while (line != null && !this.doClose) {
                if (this.listener != null) {
                    this.listener.info(line);
                }
                this.result.appendOutput(line + Sfv.LSEP);
                line = this.reader.readLine();
            }
        }
        catch (Exception oops) {
            oops.printStackTrace();
        }
        finally {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }
}

