/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.StringServices;

public class ResourceServices {
    private static Log logger = LogFactory.getLog(ResourceServices.class);

    public static ImageIcon getButtonIcon(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        URL iconUrl = loader.getResource(name);
        if (iconUrl == null) {
            iconUrl = ResourceServices.class.getResource(name);
        }
        if (iconUrl == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(iconUrl, name);
        return icon;
    }

    public static String getXmlTemplate(String name) throws IOException {
        return ResourceServices.getXmlTemplate(null, name);
    }

    public static String getXmlTemplate(String language, String name) throws IOException {
        String path;
        URL url = null;
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (language != null && language.length() > 0 && (url = loader.getResource(path = "/templates/xml/" + language.toLowerCase() + "/" + name)) == null) {
            url = ResourceServices.class.getResource(path);
        }
        if (url == null && (url = loader.getResource(path = "/templates/xml/default/" + name)) == null) {
            url = ResourceServices.class.getResource(path);
        }
        if (url == null) {
            return null;
        }
        return ResourceServices.readUrl(url);
    }

    public static String getResourceAsString(String name) throws IOException {
        return ResourceServices.getResourceAsString(name, null);
    }

    public static String getResourceAsString(String name, ClassLoader classLoader) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        InputStream is = ResourceServices.getResourceAsStream(name, classLoader);
        if (is == null) {
            return null;
        }
        return ResourceServices.readStream(is);
    }

    public static String readStream(InputStream is) throws UnsupportedEncodingException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("The argument is must not be null!");
        }
        InputStreamReader isr = new InputStreamReader(is, "UTF-8");
        BufferedReader reader = new BufferedReader(isr);
        StringBuffer buffer = new StringBuffer();
        String lsep = System.getProperty("line.separator");
        String line = reader.readLine();
        while (line != null) {
            buffer.append(line + lsep);
            line = reader.readLine();
        }
        reader.close();
        isr.close();
        is.close();
        return buffer.toString();
    }

    public static URL getResourceAsUrl(String name) {
        URL url = null;
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        url = loader.getResource(name);
        if (url == null) {
            url = ResourceServices.class.getResource(name);
        }
        return url;
    }

    public static URL getResourceAsUrl(String name, ClassLoader classLoader) {
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("The argument classLoader must not be null!");
        }
        URL url = null;
        url = classLoader.getResource(name);
        if (url == null) {
            return ResourceServices.getResourceAsUrl(name);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String name) throws IOException {
        return ResourceServices.getResourceAsStream(name, null);
    }

    public static InputStream getResourceAsStream(String name, ClassLoader classLoader) throws IOException {
        URL url = classLoader != null ? ResourceServices.getResourceAsUrl(name, classLoader) : ResourceServices.getResourceAsUrl(name);
        if (url == null) {
            return null;
        }
        return url.openStream();
    }

    public static ImageIcon getIcon(String path) {
        return ResourceServices.getIcon(path, null);
    }

    public static ImageIcon getIcon(String path, ClassLoader loader) {
        URL iconUrl = null;
        if (loader != null) {
            iconUrl = loader.getResource(path);
        }
        if (iconUrl == null) {
            iconUrl = ClassLoader.getSystemClassLoader().getResource(path);
        }
        if (iconUrl == null) {
            iconUrl = ResourceServices.class.getResource(path);
        }
        if (iconUrl == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(iconUrl, path);
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDirectory(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        BufferedReader reader = null;
        if (!name.endsWith("/")) {
            name = name + "/";
        }
        try {
            String buffer = ResourceServices.getResourceAsString(name);
            if (buffer == null) {
                throw new IOException("Can't find resource " + name);
            }
            reader = new BufferedReader(new StringReader(buffer));
            String entry = reader.readLine();
            if (entry != null) {
                entry = name + entry;
                logger.debug((Object)("entry=" + entry));
                String str = ResourceServices.getResourceAsString(entry);
                if (str == null) {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException oops) {
            logger.error((Object)oops);
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException oops) {
                    logger.error((Object)oops);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] list(String name) {
        logger.debug((Object)("list " + name));
        if (!ResourceServices.isDirectory(name)) {
            logger.error((Object)("Resource " + name + " is not a directory!"));
            return new String[0];
        }
        BufferedReader reader = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            String buffer = ResourceServices.getResourceAsString(name);
            reader = new BufferedReader(new StringReader(buffer));
            String entry = reader.readLine();
            while (entry != null) {
                list.add(entry);
                entry = reader.readLine();
            }
            String[] listing = new String[list.size()];
            Iterator iterator = list.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                entry = (String)iterator.next();
                listing[i++] = entry;
            }
            String[] stringArray = listing;
            return stringArray;
        }
        catch (IOException oops) {
            logger.error((Object)oops);
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException oops) {
                    logger.error((Object)oops);
                }
            }
        }
    }

    public static void copyToDir(String name, String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("The argument path must not be null!");
        }
        ResourceServices.copyToDir(name, new File(path));
    }

    public static void copyToDir(String name, File dir) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        if (dir == null) {
            throw new IllegalArgumentException("The argument dir must not be null!");
        }
        logger.debug((Object)("Resource: " + name + ", Directory: " + dir.getPath()));
        FileServices.createPath(dir);
        String resourceName = name;
        resourceName = StringServices.chop(resourceName, "/");
        int index = resourceName.lastIndexOf(47);
        if (index != -1) {
            resourceName = resourceName.substring(index + 1);
        }
        if (ResourceServices.isDirectory(name)) {
            if (!name.endsWith("/")) {
                name = name + "/";
            }
            logger.debug((Object)("Examination of directory " + name + "..."));
            String[] listing = ResourceServices.list(name);
            for (int i = 0; i < listing.length; ++i) {
                logger.debug((Object)("listing[" + i + "] = " + listing[i]));
                ResourceServices.copyToDir(name + listing[i], FileServices.appendFileName(dir, resourceName));
            }
        } else {
            InputStream instr = ResourceServices.getResourceAsStream(name);
            if (instr == null) {
                throw new IOException("Can't find resource " + name);
            }
            String fileName = FileServices.appendFileName(dir, resourceName);
            logger.debug((Object)("Writing resource " + fileName + "..."));
            FileOutputStream outstr = new FileOutputStream(fileName);
            int n = 0;
            byte[] buffer = new byte[4096];
            while ((n = instr.read(buffer, 0, 4096)) != -1) {
                outstr.write(buffer, 0, n);
            }
            instr.close();
            outstr.close();
        }
    }

    public static void copyToFile(String name, String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("The argument fileName must not be null!");
        }
        ResourceServices.copyToFile(name, new File(fileName));
    }

    public static void copyToFile(String name, File file) throws IOException {
        InputStream instr;
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        if (file.exists() && !file.isFile()) {
            throw new IllegalArgumentException("The argument file must be a regular file!");
        }
        if (ResourceServices.isDirectory(name)) {
            throw new IllegalArgumentException("The resource must not be a directory!");
        }
        logger.debug((Object)("Resource: " + name + ", Datei: " + file.getPath()));
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            FileServices.createPath(dir);
        }
        String resourceName = name;
        int index = (resourceName = StringServices.chop(resourceName, "/")).lastIndexOf(47);
        if (index != -1) {
            resourceName = resourceName.substring(index + 1);
        }
        if ((instr = ResourceServices.getResourceAsStream(name)) == null) {
            throw new IOException("Can't find resource " + name);
        }
        String fileName = FileServices.appendFileName(dir, file.getName());
        logger.debug((Object)("Writing resource " + fileName + "..."));
        FileOutputStream outstr = new FileOutputStream(fileName);
        int n = 0;
        byte[] buffer = new byte[4096];
        while ((n = instr.read(buffer, 0, 4096)) != -1) {
            outstr.write(buffer, 0, n);
        }
        instr.close();
        outstr.close();
    }

    public static String getString(ResourceBundle res, String key) {
        if (res == null && key == null) {
            return "(null)";
        }
        if (res == null) {
            return key;
        }
        if (key == null) {
            return "";
        }
        try {
            return res.getString(key);
        }
        catch (MissingResourceException oops) {
            logger.error((Object)("Missing resource '" + key + "'."), (Throwable)oops);
            return key;
        }
    }

    public static String readUrl(URL resourceUrl) throws UnsupportedEncodingException, IOException {
        if (resourceUrl == null) {
            throw new IllegalArgumentException("The argument resourceUrl must not be null!");
        }
        return ResourceServices.readStream(resourceUrl.openStream());
    }
}

