/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.progress.ConsoleInfoListener;
import org.dbdoclet.progress.InfoListener;
import org.dbdoclet.service.ExecResult;
import org.dbdoclet.service.ExecServices;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.StringServices;

public class LaunchServices {
    private static Log logger = LogFactory.getLog(LaunchServices.class);

    public static void execJavaClass(String javaHome, String className, InfoListener listener) {
        if (javaHome == null) {
            throw new IllegalArgumentException("The argument javaHome must not be null!");
        }
        if (className == null) {
            throw new IllegalArgumentException("The argument className must not be null!");
        }
        String javaBin = FileServices.appendPath(javaHome, "bin");
        javaBin = FileServices.appendFileName(javaBin, "java");
        javaBin = javaBin + " -classpath " + System.getProperty("java.class.path") + " " + className;
        logger.debug((Object)("javaBin=" + javaBin));
        ExecResult res = ExecServices.exec(javaBin, listener);
        if (res.failed()) {
            if (res.getThrowable() != null) {
                logger.fatal((Object)res.getOutput(), res.getThrowable());
            } else {
                logger.fatal((Object)res.getOutput());
            }
        }
    }

    public static File getResourceFile(Class<? extends Object> clazz, String resource) throws IOException {
        File file;
        int index;
        if (clazz == null) {
            throw new IllegalArgumentException("The argument clazz may not be null!");
        }
        if (resource == null) {
            throw new IllegalArgumentException("The argument resource may not be null!");
        }
        String jarPrefix = "jar:file:";
        String filePrefix = "file:";
        ClassLoader loader = clazz.getClassLoader();
        URL url = loader.getResource(resource);
        if (url == null) {
            url = ClassLoader.getSystemClassLoader().getResource(resource);
        }
        if (url == null) {
            String msg = "Can't find resource [" + resource + "]";
            logger.fatal((Object)msg);
            throw new FileNotFoundException(msg);
        }
        String buffer = url.toString();
        if ((buffer = URLDecoder.decode(buffer, "UTF-8")).equals(jarPrefix) || buffer.equals(filePrefix)) {
            String msg = "Invalid url [" + buffer + "].";
            logger.fatal((Object)msg);
            throw new FileNotFoundException(msg);
        }
        if (!buffer.startsWith(jarPrefix) && !buffer.startsWith(filePrefix)) {
            String msg = "Unknown url format [" + buffer + "]. Unknown prefix.";
            logger.fatal((Object)msg);
            throw new FileNotFoundException(msg);
        }
        if (buffer.startsWith(jarPrefix)) {
            buffer = buffer.substring(jarPrefix.length());
        }
        if (buffer.startsWith(filePrefix)) {
            buffer = buffer.substring(filePrefix.length());
        }
        if ((index = buffer.lastIndexOf("!/" + resource)) != -1) {
            buffer = buffer.substring(0, index);
        }
        if (!(file = new File(buffer)).exists()) {
            String msg = "No such file [" + file.getCanonicalPath() + "]!";
            logger.fatal((Object)("buffer=" + buffer));
            logger.fatal((Object)msg);
            throw new FileNotFoundException(msg);
        }
        return file;
    }

    public static File getHome(Class<? extends Object> clazz, String pattern) throws IOException, PatternSyntaxException {
        if (clazz == null) {
            throw new IllegalArgumentException("The argument clazz may not be null!");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("The argument pattern may not be null!");
        }
        String resource = clazz.getName();
        resource = StringServices.replace(resource, ".", "/");
        resource = resource + ".class";
        return LaunchServices.getHome(clazz, resource, pattern);
    }

    public static File getHome(Class<? extends Object> clazz, String resource, String pattern) throws IOException, PatternSyntaxException {
        if (clazz == null) {
            throw new IllegalArgumentException("The argument clazz must not be null!");
        }
        if (resource == null) {
            throw new IllegalArgumentException("The argument resource must not be null!");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("The argument pattern may not be null!");
        }
        File jarFile = LaunchServices.getResourceFile(clazz, resource);
        String path = jarFile.getCanonicalPath();
        path = StringServices.replace(path, "\\", "/");
        logger.debug((Object)("path = " + path));
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(path);
        if (!matcher.matches()) {
            return null;
        }
        if (matcher.groupCount() != 1) {
            throw new IOException("Wrong number of groups [" + matcher.groupCount() + "]");
        }
        path = matcher.group(1);
        File home = new File(path);
        if (!home.exists()) {
            String msg = "No such file [" + jarFile.getCanonicalPath() + "]!";
            logger.fatal((Object)msg);
            throw new FileNotFoundException(msg);
        }
        logger.debug((Object)("Installation directory: " + home.getPath()));
        return home;
    }

    public static boolean getSnrProperty(String property) {
        if (property == null || property.length() == 0) {
            return false;
        }
        String[] tokens = property.split("-");
        if (tokens.length != 5) {
            return false;
        }
        block7: for (int i = 0; i < tokens.length; ++i) {
            int value = Integer.parseInt(tokens[i], 16);
            switch (i) {
                case 0: {
                    if (value % 23 == 0) continue block7;
                    return false;
                }
                case 1: {
                    if (value % 11 == 0) continue block7;
                    return false;
                }
                case 2: {
                    if (value % 16 == 0) continue block7;
                    return false;
                }
                case 3: {
                    if (value % 7 == 0) continue block7;
                    return false;
                }
                case 4: {
                    if (value % 28 == 0) continue block7;
                    return false;
                }
            }
        }
        return true;
    }

    public static void main(String[] args) {
        LaunchServices.execJavaClass("/usr/local/java/jdk-1.6", "org.dbdoclet.service.LaunchServices", new ConsoleInfoListener());
    }
}

